/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.biz.config.OrderInformMqConfig;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.MqCommonDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IMqMessageService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderInformMqService {
    private Logger logger = LoggerFactory.getLogger(OrderInformMqService.class);
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private IMqMessageService mqMessageService;
    @Resource
    private OrderInformMqConfig orderInformMqConfig;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    private static final String SRC_SYSTEM = "OTHER";

    public void sendDeliverOrderInformMq(String messageKey) {
        MqCommonDto mqCommonDto = new MqCommonDto();
        mqCommonDto.setMessageKey(messageKey);
        mqCommonDto.setSrcSystem(SRC_SYSTEM);
        mqCommonDto.setOrigin(false);
        mqCommonDto.setContent(null);
        mqCommonDto.setMethod(this.orderInformMqConfig.getMethod());
        mqCommonDto.setUrl(this.orderInformMqConfig.getUrl());
        String msg = JSONObject.toJSONString((Object)mqCommonDto);
        this.logger.info("=================\u53d1\u9001\u53d1\u8d27\u901a\u77e5\u5355MQ================={}", (Object)msg);
        this.mqService.sendSingleMessage(this.orderInformMqConfig.getDeliverOrderInformExchange(), this.orderInformMqConfig.getDeliverOrderInformRouteKey(), (Object)msg);
    }

    public void sendReceiveOrderInformMq(String messageKey) {
        MqCommonDto mqCommonDto = new MqCommonDto();
        mqCommonDto.setMessageKey(messageKey);
        mqCommonDto.setSrcSystem(SRC_SYSTEM);
        mqCommonDto.setOrigin(false);
        mqCommonDto.setContent(null);
        mqCommonDto.setMethod(this.orderInformMqConfig.getReceiveMethod());
        mqCommonDto.setUrl(this.orderInformMqConfig.getUrl());
        String msg = JSONObject.toJSONString((Object)mqCommonDto);
        this.logger.info("=================\u53d1\u9001\u6536\u8d27\u901a\u77e5\u5355MQ================={}", (Object)msg);
        this.mqService.sendSingleMessage(this.orderInformMqConfig.getReceiveOrderInformExchange(), this.orderInformMqConfig.getReceiveOrderInFormRouteKey(), (Object)msg);
    }

    private MqContentOrderDto getMqContentOrder(String orderNo) {
        return null;
    }
}

