/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics;

import com.dtyunxi.yundt.cube.center.inventory.anno.cs.inventory.CsInventorySourceTypeHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventorySourceTypeHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="csInventorySourceTypeHandleUtils")
public class CsInventorySourceTypeHandleUtils {
    private static final Logger logger = LoggerFactory.getLogger(CsInventorySourceTypeHandleUtils.class);
    @Autowired
    private List<ICsInventorySourceTypeHandler> inventorySourceTypeHandlerList;

    @PostConstruct
    public void init() {
        if (CollectionUtils.isEmpty(this.inventorySourceTypeHandlerList)) {
            return;
        }
        ListIterator<ICsInventorySourceTypeHandler> iterator = this.inventorySourceTypeHandlerList.listIterator();
        while (iterator.hasNext()) {
            ICsInventorySourceTypeHandler inventorySourceTypeHandler = iterator.next();
            boolean effect = inventorySourceTypeHandler.getClass().getAnnotation(CsInventorySourceTypeHandler.class).effect();
            if (effect) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(this.inventorySourceTypeHandlerList)) {
            return;
        }
        this.inventorySourceTypeHandlerList.stream().sorted(Comparator.comparing(handle -> {
            int priority = handle.getClass().getAnnotation(CsInventorySourceTypeHandler.class).priority();
            priority = priority < 0 || priority > 9 ? 9 : priority;
            return priority;
        }));
        logger.info("handler\u521d\u59cb\u5316\u5b8c\u6bd5,inventorySourceTypeHandlerList:{}", (Object)LogUtils.buildLogContent(this.inventorySourceTypeHandlerList));
    }

    public void doHandler(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        logger.info("doHandler==>\u5904\u7406\u65b9\u6cd5,inParamDto:{},successList:{},inventorySourceTypeHandlerList:{}", new Object[]{LogUtils.buildLogContent(inParamDto), LogUtils.buildLogContent(successList), LogUtils.buildLogContent(this.inventorySourceTypeHandlerList)});
        if (CollectionUtils.isEmpty(this.inventorySourceTypeHandlerList)) {
            return;
        }
        String sourceType = inParamDto.getSourceType();
        CsInventorySourceTypeEnum inventorySourceTypeEnum = CsInventorySourceTypeEnum.getByCode((String)sourceType);
        if (null == inventorySourceTypeEnum) {
            return;
        }
        for (ICsInventorySourceTypeHandler handler : this.inventorySourceTypeHandlerList) {
            CsInventorySourceTypeEnum[] csInventorySourceTypeEnumArr = handler.getClass().getAnnotation(CsInventorySourceTypeHandler.class).sourceType();
            List<CsInventorySourceTypeEnum> csInventorySourceTypeEnumList = Arrays.asList(csInventorySourceTypeEnumArr);
            if (CollectionUtils.isEmpty(csInventorySourceTypeEnumList) || !csInventorySourceTypeEnumList.contains(inventorySourceTypeEnum)) continue;
            handler.handle(inParamDto, successList);
        }
    }
}

