/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.EditCustomerSaveTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseSupplyConfigService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseSupplyRelService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseSupplyRelDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseSupplyRelEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.vo.DeliveryConfigVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class WarehouseSupplyRelServiceImpl
implements IWarehouseSupplyRelService {
    private static final Logger log = LoggerFactory.getLogger(WarehouseSupplyRelServiceImpl.class);
    @Resource
    private WarehouseSupplyRelDas warehouseSupplyRelDas;
    @Resource
    private IWarehouseSupplyConfigService warehouseSupplyConfigService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;

    @Override
    public Long addWarehouseSupplyRel(WarehouseSupplyRelReqDto addReqDto) {
        log.info("\u6307\u5b9a\u5ba2\u6237\u53d1\u8d27\u4ed3\u914d\u7f6e reqParams is {} . ", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.assertTrue(!CollectionUtils.isEmpty((Collection)addReqDto.getWarehouseCodeList()), "\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        AssertUtil.assertNotNull(addReqDto.getOrganizationId(), "\u7ec4\u7ec7ID\u4e3a\u7a7a");
        AssertUtil.assertNotNull(addReqDto.getCustomerId(), "\u5ba2\u6237ID\u4e3a\u7a7a");
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = new WarehouseSupplyRelReqDto();
        warehouseSupplyRelReqDto.setWarehouseCode(addReqDto.getWarehouseCode());
        Page warehouseSupplyRelRespDtoPage = this.warehouseSupplyRelDas.queryWarehousePage(warehouseSupplyRelReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        AssertUtil.assertTrue(!CollectionUtils.isEmpty((Collection)warehouseSupplyRelRespDtoPage.getResult()), "\u5f53\u524d\u4ed3\u5e93\u4e0d\u5b58\u5728");
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(addReqDto.getCustomerId()));
        AssertUtil.assertNotNull(customerRespDto, "\u5ba2\u6237\u4e0d\u5b58\u5728");
        WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = (WarehouseSupplyRelRespDto)warehouseSupplyRelRespDtoPage.getResult().stream().findFirst().get();
        CustomerReqExtDto customerReqExtDto = new CustomerReqExtDto();
        CubeBeanUtils.copyProperties((Object)customerReqExtDto, (Object)customerRespDto, (String[])new String[0]);
        customerReqExtDto.setIsWarehouseEnable(warehouseSupplyRelRespDto.getMainWarehouse());
        customerReqExtDto.setSaveType(EditCustomerSaveTypeEnum.CUSTOMER.getCode());
        this.customerExtThreeApi.update(customerReqExtDto);
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setOrganizationId(addReqDto.getOrganizationId());
        warehouseSupplyConfigReqDto.setCustomerCode(customerRespDto.getCode());
        PageInfo<WarehouseSupplyConfigRespDto> warehouseSupplyConfigRespDtoPageInfo = this.warehouseSupplyConfigService.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), 1, Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty((Collection)warehouseSupplyConfigRespDtoPageInfo.getList())) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationId(addReqDto.getOrganizationId());
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
            Optional first = sellerRespDtos.stream().findFirst();
            AssertUtil.assertTrue(first.isPresent(), "\u672a\u914d\u7f6e\u9ed8\u8ba4\u4f9b\u5e94\u5546");
            PageInfo shopDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBySellerId(((SellerRespDto)first.get()).getId().longValue(), 1, Integer.MAX_VALUE));
            AssertUtil.assertTrue(!CollectionUtils.isEmpty((Collection)shopDtoPageInfo.getList()), "\u672a\u914d\u7f6e\u9ed8\u8ba4\u4f9b\u5e94\u5546");
            WarehouseSupplyConfigReqDto warehouseSupplyConfig = new WarehouseSupplyConfigReqDto(((ShopDto)shopDtoPageInfo.getList().stream().findFirst().get()).getId(), addReqDto.getOrganizationId(), addReqDto.getOrganizationCode(), addReqDto.getOrganizationName(), ItemInventoryStrategyEnum.SEPARATE.getTypeCode(), customerRespDto.getId(), customerRespDto.getCode());
            this.warehouseSupplyConfigService.addWarehouseSupplyConfig(warehouseSupplyConfig);
        }
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        warehouseSupplyRelEo.setCustomerId(addReqDto.getCustomerId());
        this.warehouseSupplyRelDas.delete((BaseEo)warehouseSupplyRelEo);
        List collect = addReqDto.getWarehouseCodeList().stream().map(warehouseCode -> new WarehouseSupplyRelEo(customerRespDto.getId(), customerRespDto.getCode(), YesNoEnum.YES.getValue(), warehouseCode, addReqDto.getOrganizationId())).collect(Collectors.toList());
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)warehouseSupplyRelEo);
        this.warehouseSupplyRelDas.insertBatch(collect);
        return null;
    }

    @Override
    public void modifyWarehouseSupplyRel(WarehouseSupplyRelReqDto modifyReqDto) {
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseSupplyRelEo);
        this.warehouseSupplyRelDas.updateSelective((BaseEo)warehouseSupplyRelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseSupplyRel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseSupplyRelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseSupplyRelRespDto queryById(Long id) {
        WarehouseSupplyRelEo warehouseSupplyRelEo = (WarehouseSupplyRelEo)this.warehouseSupplyRelDas.selectByPrimaryKey(id);
        WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = new WarehouseSupplyRelRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseSupplyRelEo, (BaseVo)warehouseSupplyRelRespDto);
        return warehouseSupplyRelRespDto;
    }

    @Override
    public PageInfo<WarehouseSupplyRelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = (WarehouseSupplyRelReqDto)JSON.parseObject((String)filter, WarehouseSupplyRelReqDto.class);
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        DtoHelper.dto2Eo((BaseVo)warehouseSupplyRelReqDto, (BaseEo)warehouseSupplyRelEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)warehouseSupplyRelReqDto.getCustomerIds())) {
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)warehouseSupplyRelReqDto.getCustomerIds()));
        }
        warehouseSupplyRelEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.warehouseSupplyRelDas.selectPage((BaseEo)warehouseSupplyRelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseSupplyRelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<WarehouseSupplyRelRespDto> queryByCustomerId(String customerId) {
        WarehouseSupplyRelEo params = new WarehouseSupplyRelEo();
        params.setCustomerId(Long.valueOf(customerId));
        List select = this.warehouseSupplyRelDas.select((BaseEo)params);
        ArrayList warehouseSupplyRelRespDto = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)select, (Collection)warehouseSupplyRelRespDto, WarehouseSupplyRelRespDto.class);
        return warehouseSupplyRelRespDto;
    }

    @Override
    public PageInfo<WarehouseSupplyRelRespDto> queryWarehousePage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = (WarehouseSupplyRelReqDto)JSON.parseObject((String)filter, WarehouseSupplyRelReqDto.class);
        AssertUtil.assertTrue(!ObjectUtils.isEmpty((Object)warehouseSupplyRelReqDto.getOrganizationId()), "\u7ec4\u7ec7ID\u4e3a\u7a7a");
        Page warehouseSupplyRelEos = this.warehouseSupplyRelDas.queryWarehousePage(warehouseSupplyRelReqDto, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)warehouseSupplyRelEos, (String[])new String[]{"list", "navigatepageNums"});
        List warehouseSupplyRelEoList = warehouseSupplyRelEos.getResult();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)warehouseSupplyRelEoList)) {
            respDtoPageInfo.setList(warehouseSupplyRelEoList);
        }
        return respDtoPageInfo;
    }

    @Override
    public BizImportRespDto importWarehouseSupplyRel(BizImportRespDto<DeliveryConfigVo> addReqDto) {
        List importVoList = addReqDto.getObjects();
        Integer total = importVoList.size();
        Integer importSuccessTotal = 0;
        Integer importFailTotal = 0;
        List<Object> exportVoList = Lists.newArrayList();
        List customerCodes = importVoList.stream().map(c -> c.getCustomerCode()).collect(Collectors.toList());
        List customerExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtThreeQueryApi.queryByCodeList(customerCodes));
        Map<String, CustomerExtRespDto> customerExtRespDtoMap = customerExtRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, v -> v, (k1, k2) -> k1));
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        csLogicWarehouseQueryDto.setOrganizationId(addReqDto.getOrgId());
        csLogicWarehouseQueryDto.setPageNum(Integer.valueOf(1));
        csLogicWarehouseQueryDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<CsLogicWarehouseRespDto> csLogicWarehouseRespDtoPageInfo = this.csLogicWarehouseQueryService.queryByPage(csLogicWarehouseQueryDto);
        List logicWarehouseRespDtos = Optional.ofNullable(csLogicWarehouseRespDtoPageInfo.getList()).orElse(Lists.newArrayList());
        Map<String, CsLogicWarehouseRespDto> warehouseRespDtoMap = logicWarehouseRespDtos.stream().filter(c -> CsWarehouseTypeEnum.PRODUCT_WAREHOUSE.getDesc().equals(c.getWarehouseType())).collect(Collectors.toMap(k -> k.getWarehouseCode(), v -> v, (k1, k2) -> k1));
        importVoList.forEach(c -> {
            CsLogicWarehouseRespDto csLogicWarehouseRespDto;
            CustomerExtRespDto customerExtRespDto = (CustomerExtRespDto)customerExtRespDtoMap.get(c.getCustomerCode());
            if (ObjectUtils.isEmpty((Object)customerExtRespDto)) {
                c.setErrorDesc("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            if (ObjectUtils.isEmpty((Object)(csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)warehouseRespDtoMap.get(c.getWarehouseCode())))) {
                c.setErrorDesc("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                customerExtRespDto.setIsWarehouseEnable(csLogicWarehouseRespDto.getMainWarehouse());
                CustomerReqExtDto customerReqExtDto = new CustomerReqExtDto();
                CubeBeanUtils.copyProperties((Object)customerReqExtDto, (Object)customerExtRespDto, (String[])new String[0]);
                this.customerExtThreeApi.update(customerReqExtDto);
            }
        });
        exportVoList = importVoList.stream().filter(c -> !StringUtils.isEmpty((Object)c.getErrorDesc())).collect(Collectors.toList());
        importFailTotal = exportVoList.size();
        importSuccessTotal = total - importFailTotal;
        List<DeliveryConfigVo> collect = importVoList.stream().filter(c -> c.getErrorDesc().isEmpty()).collect(Collectors.toList());
        collect.forEach(configDto -> {
            WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = new WarehouseSupplyRelReqDto();
            warehouseSupplyRelReqDto.setCustomerId(((CustomerExtRespDto)customerExtRespDtoMap.get(configDto.getCustomerCode())).getCustomerId());
            warehouseSupplyRelReqDto.setWarehouseCode(configDto.getWarehouseCode());
            warehouseSupplyRelReqDto.setOrganizationId(addReqDto.getOrgId());
            this.addWarehouseSupplyRel(warehouseSupplyRelReqDto);
        });
        String url = "";
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(exportVoList)) {
            String excelName = "cube/\u5206\u4ed3\u914d\u7f6e\u5bfc\u5165\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                url = EasyPoiExportUtil.getExportUrl(exportVoList, DeliveryConfigVo.class, (String)null, (String)excelName, (String)"xls");
                log.info("\u3010\u5bfc\u5165\u5206\u4ed3\u914d\u7f6e\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
            }
            catch (Exception var15) {
                log.error("\u5bfc\u51fa\u5206\u4ed3\u914d\u7f6e-\u9519\u8bef:{}", (Object)var15.toString());
                var15.printStackTrace();
            }
        }
        return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
    }

    private void verifyExportData(BizImportRespDto addReqDto, List<DeliveryConfigVo> exportVoList, List<DeliveryConfigVo> importVoList, Integer total) {
    }
}

