/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.yundt.cube.center.inventory.anno.cs.inventory.CsInventorySourceTypeHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventorySourceTypeHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsInventoryPreemptionDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsInventoryPreemptionEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsInventoryPreemptionMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="csCommonInventoryOutInventoryHandler")
@CsInventorySourceTypeHandler(sourceType={CsInventorySourceTypeEnum.OUT_SALE_PREEMPT, CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT, CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT, CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT, CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT, CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT, CsInventorySourceTypeEnum.OUT_OTHER_PREEMPT, CsInventorySourceTypeEnum.OUT_SEPARATE_PREEMPT, CsInventorySourceTypeEnum.OUT_BACKTRACK_PREEMPT, CsInventorySourceTypeEnum.OUT_TOP_BACKTRACK_PREEMPT, CsInventorySourceTypeEnum.OUT_MATERIAL_ADJUST_PREEMPT, CsInventorySourceTypeEnum.OUT_INTERIOR_ADJUST_PREEMPT, CsInventorySourceTypeEnum.SECOND_OUT_TOP_BACKTRACK_PREEMPT}, priority=0)
public class CsCommonInventoryOutPreemptHandler
implements ICsInventorySourceTypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(CsCommonInventoryOutPreemptHandler.class);
    @Autowired
    private CsInventoryPreemptionDas csInventoryPreemptionDas;
    @Autowired
    private CsInventoryPreemptionMapper csInventoryPreemptionMapper;

    @Override
    public void handle(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        logger.info("CsInventoryOutSaleHandler==>\u5904\u7406,inParamDto:{},successListL:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(successList));
        if (CollectionUtils.isEmpty(successList)) {
            return;
        }
        this.insertInventoryPreemptionInfo(inParamDto, successList);
    }

    private void insertInventoryPreemptionInfo(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        logger.info("common_insertInventoryPreemptionInfo,inParamDto:{},successList:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(successList));
        ArrayList csInventoryPreemptionEoList = Lists.newArrayList();
        if (CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode().equals(inParamDto.getSourceType())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"source_type", (Object)inParamDto.getSourceType());
            queryWrapper.eq((Object)"source_no", (Object)inParamDto.getSourceNo());
            queryWrapper.eq((Object)"dr", (Object)0);
            List preemptionEoList = this.csInventoryPreemptionMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)preemptionEoList)) {
                return;
            }
        }
        for (CsInventoryInOutBasicsCargoDto cargoDto : successList) {
            CsInventoryPreemptionEo csInventoryPreemptionEo = new CsInventoryPreemptionEo();
            csInventoryPreemptionEo.setSourceNo(inParamDto.getSourceNo());
            csInventoryPreemptionEo.setSourceType(inParamDto.getSourceType());
            csInventoryPreemptionEo.setWarehouseId(cargoDto.getWarehouseId());
            csInventoryPreemptionEo.setWarehouseCode(cargoDto.getWarehouseCode());
            csInventoryPreemptionEo.setWarehouseName(cargoDto.getWarehouseName());
            csInventoryPreemptionEo.setWarehouseClassify(cargoDto.getWarehouseClassify());
            csInventoryPreemptionEo.setWarehouseType(cargoDto.getWarehouseType());
            csInventoryPreemptionEo.setCargoId(cargoDto.getCargoId());
            csInventoryPreemptionEo.setCargoCode(cargoDto.getCargoCode());
            csInventoryPreemptionEo.setCargoName(cargoDto.getCargoName());
            csInventoryPreemptionEo.setArtNo(cargoDto.getArtNo());
            csInventoryPreemptionEo.setBatch(cargoDto.getBatch());
            csInventoryPreemptionEo.setBatchType(cargoDto.getBatchType());
            csInventoryPreemptionEo.setIsGift(cargoDto.getIsGift());
            csInventoryPreemptionEo.setValid(CsValidFlagEnum.ENABLE.getCode());
            csInventoryPreemptionEo.setActivityId(cargoDto.getActivityId());
            csInventoryPreemptionEo.setActivityType(cargoDto.getActivityType());
            csInventoryPreemptionEo.setActivityFlag(cargoDto.getActivityFlag());
            boolean flag = Objects.nonNull(cargoDto.getActivityId()) && (CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT.getCode().equals(inParamDto.getSourceType()) || CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(inParamDto.getSourceType()) || CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT.getCode().equals(inParamDto.getSourceType()));
            csInventoryPreemptionEo.setDisplay(flag ? YesNoEnum.NO.getValue() : YesNoEnum.YES.getValue());
            BigDecimal preempt = cargoDto.getPreempt();
            if (CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode().equals(inParamDto.getSourceType())) {
                preempt = cargoDto.getBalance();
                csInventoryPreemptionEo.setSourceNo(inParamDto.getSourceNo());
                csInventoryPreemptionEo.setValid(CsValidFlagEnum.DISABLE.getCode());
            }
            preempt = preempt == null ? BigDecimal.ZERO : preempt;
            csInventoryPreemptionEo.setPreemptNum(preempt);
            csInventoryPreemptionEoList.add(csInventoryPreemptionEo);
        }
        this.csInventoryPreemptionMapper.insertBatch((List)csInventoryPreemptionEoList);
    }
}

