/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsReceiveResultOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInResultOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsReceiveNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsReceiveResultOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsReceiveResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsReceiveNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsReceiveResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsReceiveResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csReceiveResultOrderService")
public class CsReceiveResultOrderServiceImpl
implements ICsReceiveResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveResultOrderServiceImpl.class);
    @Autowired
    private CsReceiveResultOrderDas csReceiveResultOrderDas;
    @Resource
    private CsReceiveResultOrderMapper csReceiveResultOrderMapper;
    @Resource
    private CsReceiveNoticeOrderMapper csReceiveNoticeOrderMapper;
    @Resource
    private CsReceiveResultOrderDetailMapper csReceiveResultOrderDetailMapper;
    @Resource
    private CsLogicWarehouseMapper csLogicWarehouseMapper;
    @Resource
    private CsInResultOrderDetailMapper csInResultOrderDetailMapper;
    @Resource
    private CsCommonService csCommonService;
    @Autowired
    private ICsReceiveResultOrderQueryService csReceiveResultOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsReceiveResultOrderAddReqDto addReqDto) {
        logger.info("\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355,\u5165\u53c2\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("ReceiveResult:" + addReqDto.getPreOrderNo(), () -> this.validParam(addReqDto), true);
        CsReceiveResultOrderEo resultOrderEo = new CsReceiveResultOrderEo();
        CubeBeanUtils.copyProperties((Object)resultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("202");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        resultOrderEo.setDocumentNo(documentNo);
        resultOrderEo.setOrderStatus(orderStatus);
        resultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.csReceiveResultOrderMapper.insert((Object)resultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsReceiveResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsReceiveResultOrderDetailEo detailEo = new CsReceiveResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setArtNo(this.csCommonService.getItemCode(detailEo.getCargoCode()));
            detailEo.setDocumentNo(documentNo);
            detailEoList.add(detailEo);
        }
        this.csReceiveResultOrderDetailMapper.insertBatch((List)detailEoList);
        logger.info("\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355,id\uff1a[id:{}]", (Object)resultOrderEo.getId());
        return resultOrderEo.getId();
    }

    private void validParam(CsReceiveResultOrderAddReqDto addReqDto) {
        List oldList = this.csReceiveResultOrderMapper.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsReceiveResultOrderEo receiveResultOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.RECEIVE_CANCEL.getCode().equals(receiveResultOrderEo.getOrderStatus()), "304", receiveResultOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
        List csReceiveNoticeOrderEos = this.csReceiveNoticeOrderMapper.queryByPreOrderNo(addReqDto.getPreOrderNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csReceiveNoticeOrderEos), addReqDto.getPreOrderNo() + "\u4e0d\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u901a\u77e5\u5355\u636e");
        addReqDto.setRelevanceNo(((CsReceiveNoticeOrderEo)csReceiveNoticeOrderEos.get(0)).getDocumentNo());
        List logicWarehouseEos = this.csLogicWarehouseMapper.queryByWarehouseCode(addReqDto.getWarehouseCode());
        List<String> cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsReceiveResultOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List<CargoEo> cargoEoList = this.csCommonService.queryCargo(cargoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoEoList), "\u8d27\u54c1\u672a\u914d\u7f6e");
        CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, CargoEo> cargoMap = cargoEoList.stream().collect(Collectors.toMap(StdCargoEo::getCode, entity -> entity));
        BigDecimal totalQuantity = BigDecimal.ZERO;
        List csInResultOrderDetailEos = this.csInResultOrderDetailMapper.queryByPreOrderNo(addReqDto.getPreOrderNo());
        HashMap<String, CsInResultOrderDetailEo> timeMap = new HashMap<String, CsInResultOrderDetailEo>();
        if (CollectionUtils.isNotEmpty((Collection)csInResultOrderDetailEos)) {
            for (CsInResultOrderDetailEo csInResultOrderDetailEo : csInResultOrderDetailEos) {
                timeMap.put(csInResultOrderDetailEo.getCargoCode() + csInResultOrderDetailEo.getBatch(), csInResultOrderDetailEo);
            }
        }
        for (CsReceiveResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CargoEo cargoEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == cargoEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            CsInResultOrderDetailEo csInResultOrderDetailEo = (CsInResultOrderDetailEo)timeMap.get(detailAddReqDto.getCargoCode() + detailAddReqDto.getBatch());
            if (null != csInResultOrderDetailEo) {
                detailAddReqDto.setExpireTime(csInResultOrderDetailEo.getExpireTime());
                detailAddReqDto.setProduceTime(csInResultOrderDetailEo.getProduceTime());
            }
            detailAddReqDto.setCargoId(cargoEo.getId());
            detailAddReqDto.setCargoName(cargoEo.getName());
            totalQuantity = totalQuantity.add(detailAddReqDto.getQuantity());
        }
        addReqDto.setTotalQuantity(totalQuantity);
    }

    @Override
    public void update(Long id, CsReceiveResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsReceiveResultOrderEo updateEo = CsReceiveResultOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csReceiveResultOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveResultOrderQueryService.selectByPrimaryKey(id);
        this.csReceiveResultOrderDas.logicDeleteById(id);
    }
}

