/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

@Service(value="csReceiveNoticeOrderApi")
public class CsReceiveNoticeOrderApiImpl
implements ICsReceiveNoticeOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveNoticeOrderApiImpl.class);
    @Autowired
    private ICsReceiveNoticeOrderService csReceiveNoticeOrderService;
    @Resource
    private ICsInNoticeOrderService csInNoticeOrderService;

    public RestResponse<Long> add(CsReceiveNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csReceiveNoticeOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsReceiveNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveNoticeOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveNoticeOrderService.delete(id);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/createReceiveOrderProcess"}, produces={"application/json"})
    public RestResponse<Long> createReceiveOrderProcess(CsReceiveNoticeOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u6d41\u7a0b\uff1a\u5165\u53c2\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        Long id = this.csReceiveNoticeOrderService.add(addReqDto);
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u6d41\u7a0b\uff1a\u6536\u8d27\u901a\u77e5\u5355id\uff1a[{}]", (Object)id);
        Long inNoticeOrderId = this.csInNoticeOrderService.createInNoticeOrder(addReqDto.getDocumentNo());
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u6d41\u7a0b\uff1a\u5165\u5e93\u901a\u77e5\u5355id\uff1a[{}]", (Object)inNoticeOrderId);
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> updateOrderStatus(String preOrderNo, String action) {
        logger.info("\u4fee\u6539\u6536\u8d27\u8d27\u5355\u5355\u636e\u72b6\u6001\uff1a[preOrderNo:{},action:{}]", (Object)preOrderNo, (Object)action);
        this.csReceiveNoticeOrderService.updateOrderStatus(preOrderNo, action);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> reCheckInInventoryOverall(CsReceiveResultOrderAddReqDto addReqDto) {
        logger.info("\u4fee\u6570-\u590d\u6838\u5165\u5e93(\u7528\u4e8e\u590d\u6838\u6210\u529f\u4f46\u662f\u6ca1\u6709\u5165\u5e93\u7684\u573a\u666f)\uff1a[addReqDto:{}]", (Object)addReqDto);
        Boolean result = this.csReceiveNoticeOrderService.reCheckInInventoryOverall(addReqDto);
        return new RestResponse((Object)result);
    }
}

