/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInventorySubItemService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderDetailQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.RollbackDeliveryOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInResultOrderApi")
public class CsInResultOrderApiImpl
implements ICsInResultOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsInResultOrderApiImpl.class);
    @Resource
    private ICsInResultOrderService csInResultOrderService;
    @Resource
    private MqService mqService;
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;
    @Resource
    private ICsInResultOrderQueryService csInResultOrderQueryService;
    @Resource
    private ICsInResultOrderDetailQueryService csInResultOrderDetailQueryService;
    @Resource
    private IInventorySubItemService inventorySubItemService;

    public RestResponse<Long> add(CsInResultOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csInResultOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsInResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csInResultOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csInResultOrderService.delete(id);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<Long> refundResultBack(TcbjResGenReqDto reqDto) {
        logger.info("\u8425\u9500\u4e91\u56de\u4f20\u9000\u8d27\u7ed3\u679c\uff0c\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355,\u5165\u53c2\uff1a[reqDto:{}]", (Object)LogUtils.buildLogContent(reqDto));
        CsInResultOrderAddReqDto addReqDto = this.changeParams(reqDto);
        Long addId = this.csInResultOrderService.add(addReqDto);
        if (BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SUB_SALE_RTN_IN.getCode().equals(addReqDto.getBusinessType())) {
            logger.info("\u8425\u9500\u4e91\u56de\u4f20\u9000\u8d27\u7ed3\u679c\uff0c\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355,id\uff1a[{}]", (Object)addId);
            MessageVo messageVo = this.getMessageVo(addReqDto);
            logger.info("\u8425\u9500\u4e91\u56de\u4f20\u9000\u8d27\u7ed3\u679c\uff0c\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355,\u83b7\u53d6\u660e\u7ec6\u56de\u4f20\uff0c\u901a\u77e5\u8ba2\u5355\u590d\u6838\uff1a[messageVo:{}]", (Object)messageVo.toString());
            this.mqService.noticeOrderDetail(messageVo);
        } else {
            try {
                logger.info("\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff1a\u8425\u9500\u4e91\u56de\u4f20\u9000\u8d27\u7ed3\u679c\uff0c\u53d8\u52a8\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58\u3001\u603b\u5e93\u5b58");
                CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = this.joinInInventoryParams(addReqDto);
                this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
                csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(e -> e.setBatch(null));
                this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
                List giftList = reqDto.getResGenItemReqDtos().stream().filter(c -> YesNoEnum.YES.getValue().equals(c.getIsGift())).collect(Collectors.toList());
                CompletableFuture.runAsync(() -> {
                    logger.info("\u5f00\u59cb\u5f02\u6b65\u5199\u5165\u793c\u76d2\u4ea7\u54c1\u5173\u7cfb : {} .", (Object)JSON.toJSONString((Object)giftList));
                    giftList.forEach(c -> this.inventorySubItemService.addInventorySubItem(c.getCargoCode(), c.getBatch(), c.getSubItemList()));
                    logger.info("\u7ed3\u675f\u5f02\u6b65\u5199\u5165\u793c\u76d2\u4ea7\u54c1\u5173\u7cfb");
                });
                logger.info("\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f\uff0c\u8425\u9500\u4e91\u56de\u4f20\u9000\u8d27\u7ed3\u679c,\u5165\u5e93\u5b8c\u6210");
            }
            catch (Exception e2) {
                logger.error("\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff1a\u8425\u9500\u4e91\u56de\u4f20\u9000\u8d27\u7ed3\u679c:{}", (Object)e2.getMessage());
                e2.printStackTrace();
            }
            if (BusinessTypeEnum.SECOND_IN_PURCHASE.getCode().equals(addReqDto.getBusinessType())) {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)reqDto.getPreNo());
                logger.info("\u8425\u9500\u4e91\u56de\u4f20\u5165\u5e93\u7ed3\u679c\uff0c\u4e8c\u7ea7\u91c7\u8d2d\u5165\u5e93 \u901a\u77e5\u8ba2\u5355\uff1a[messageVo:{}]", (Object)messageVo.toString());
                this.mqService.sendInPurchaseToOrder(messageVo);
            }
        }
        return new RestResponse((Object)addId);
    }

    public RestResponse<Void> rollbackInResultOrder(RollbackDeliveryOrderReqDto rollbackDeliveryOrderReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)rollbackDeliveryOrderReqDto.getPreOrderNo()) || StringUtils.isNotBlank((CharSequence)rollbackDeliveryOrderReqDto.getDocumentNo()) || StringUtils.isNotBlank((CharSequence)rollbackDeliveryOrderReqDto.getRelevanceNo()), "\u6807\u8bc6\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        CsInResultOrderQueryDto csInResultOrderQueryDto = new CsInResultOrderQueryDto();
        csInResultOrderQueryDto.setPreOrderNo(rollbackDeliveryOrderReqDto.getPreOrderNo());
        csInResultOrderQueryDto.setDocumentNo(rollbackDeliveryOrderReqDto.getDocumentNo());
        csInResultOrderQueryDto.setRelevanceNo(rollbackDeliveryOrderReqDto.getRelevanceNo());
        CsInResultOrderAddReqDto csInResultOrderDto = this.csInResultOrderQueryService.queryCsInResultOrderQueryDto(csInResultOrderQueryDto);
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)csInResultOrderDto), "\u5165\u5e93\u7ed3\u679c\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
        CsInResultOrderDetailAddReqDto csInResultOrderDetail = new CsInResultOrderDetailAddReqDto();
        csInResultOrderDetail.setDocumentNo(csInResultOrderDto.getDocumentNo());
        List<CsInResultOrderDetailAddReqDto> csInResultOrderDetailRespDtos = this.csInResultOrderDetailQueryService.queryCsInResultOrderDetail(csInResultOrderDetail);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(csInResultOrderDetailRespDtos), "\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38\uff01\uff01\uff01");
        csInResultOrderDto.setDetailAddReqDtoList(csInResultOrderDetailRespDtos);
        logger.info("\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u53d8\u52a8\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58\u3001\u603b\u5e93\u5b58");
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = this.joinOutInventoryParams(csInResultOrderDto);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        List collect = csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().stream().filter(c -> ObjectUtils.isNotEmpty((Object)c.getBatch())).map(e -> {
            e.setBatch(null);
            return e;
        }).collect(Collectors.toList());
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList(collect);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        logger.info("\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u51fa\u5e93\u5b8c\u6210");
        return RestResponse.SUCCESS;
    }

    private CsInventoryInOutBasicsDto joinOutInventoryParams(CsInResultOrderAddReqDto addReqDto) {
        logger.info("\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u51fa\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,addReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(Objects.requireNonNull(CsInventorySourceTypeEnum.OUT_ROLLBACK_ADJUST.getCode()));
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        for (CsInResultOrderDetailAddReqDto actDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(actDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setAvailable(actDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setWarehouseId(addReqDto.getWarehouseId());
            inOutBasicsCargoDto.setWarehouseName(addReqDto.getWarehouseName());
            inOutBasicsCargoDto.setWarehouseClassify(addReqDto.getWarehouseClassify());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(actDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(actDto.getProduceTime());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        return csInventoryInOutBasicsDto;
    }

    private CsInventoryInOutBasicsDto joinInInventoryParams(CsInResultOrderAddReqDto addReqDto) {
        logger.info("\u8425\u9500\u4e91\u56de\u4f20==>\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,addReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(Objects.requireNonNull(CsInventorySourceTypeEnum.getByValue((String)addReqDto.getBusinessType())).getCode());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        for (CsInResultOrderDetailAddReqDto actDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(actDto.getQuantity().abs());
            inOutBasicsCargoDto.setAvailable(actDto.getQuantity().abs());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setWarehouseId(addReqDto.getWarehouseId());
            inOutBasicsCargoDto.setWarehouseName(addReqDto.getWarehouseName());
            inOutBasicsCargoDto.setWarehouseClassify(addReqDto.getWarehouseClassify());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(actDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(actDto.getProduceTime());
            inOutBasicsCargoDto.setIsGift(actDto.getIsGift());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        return csInventoryInOutBasicsDto;
    }

    private MessageVo getMessageVo(CsInResultOrderAddReqDto addReqDto) {
        MessageVo messageVo = new MessageVo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderTradeStatus", (Object)"SUCC");
        jsonObject.put("orderCode", (Object)addReqDto.getPreOrderNo());
        jsonObject.put("type", (Object)"return");
        ReturnItemConfirmReqDto returnItemConfirmReqDto = new ReturnItemConfirmReqDto();
        returnItemConfirmReqDto.setReturnNo(addReqDto.getPreOrderNo());
        if (CollectionUtil.isNotEmpty((Collection)addReqDto.getDetailAddReqDtoList())) {
            List items = addReqDto.getDetailAddReqDtoList().stream().map(e -> {
                ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto = new ReturnItemConfirmDetailReqDto();
                returnItemConfirmDetailReqDto.setItemCode(e.getCargoCode());
                returnItemConfirmDetailReqDto.setItemId(e.getCargoId() + "");
                returnItemConfirmDetailReqDto.setItemName(e.getCargoName());
                returnItemConfirmDetailReqDto.setCurrentNum(Long.valueOf(e.getQuantity().longValue()));
                returnItemConfirmDetailReqDto.setCargoSerial(e.getCargoId() + "");
                returnItemConfirmDetailReqDto.setCargoCode(e.getCargoCode());
                returnItemConfirmDetailReqDto.setBatchNo(e.getBatch());
                returnItemConfirmDetailReqDto.setOrderNo(e.getPreOrderNo());
                return returnItemConfirmDetailReqDto;
            }).collect(Collectors.toList());
            returnItemConfirmReqDto.setReturnItemConfirmDetailReqDtos(items);
            jsonObject.put("items", (Object)returnItemConfirmReqDto);
        }
        messageVo.setData((Object)jsonObject);
        return messageVo;
    }

    private CsInResultOrderAddReqDto changeParams(TcbjResGenReqDto reqDto) {
        CsInResultOrderAddReqDto addReqDto = new CsInResultOrderAddReqDto();
        addReqDto.setRelevanceNo(reqDto.getNotiNo());
        addReqDto.setPreOrderNo(reqDto.getPreNo());
        addReqDto.setBusinessType(reqDto.getType() + "");
        addReqDto.setWarehouseCode(reqDto.getWarehouseCode());
        addReqDto.setExternalOrderNo(reqDto.getNotiNo());
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.valueOf(0L);
        for (TcbjResGenItemReqDto itemReqDto : reqDto.getResGenItemReqDtos()) {
            CsInResultOrderDetailAddReqDto detailAddReqDto = new CsInResultOrderDetailAddReqDto();
            CubeBeanUtils.copyProperties((Object)detailAddReqDto, (Object)itemReqDto, (String[])new String[0]);
            detailAddReqDto.setExpireTime(itemReqDto.getExpireDate());
            detailAddReqDto.setProduceTime(itemReqDto.getProductDate());
            detailAddReqDto.setQuantity(BigDecimal.valueOf(itemReqDto.getNum() == null ? 0L : (long)itemReqDto.getNum().intValue()));
            detailAddReqDto.setIsGift(itemReqDto.getIsGift());
            totalQuantity = totalQuantity.add(detailAddReqDto.getQuantity());
            detailAddReqDtoList.add(detailAddReqDto);
        }
        addReqDto.setTotalQuantity(totalQuantity);
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        ContactDto contactDto = new ContactDto();
        CubeBeanUtils.copyProperties((Object)contactDto, (Object)reqDto, (String[])new String[0]);
        addReqDto.setContactDto(contactDto);
        return addReqDto;
    }
}

