/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryNoticeOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsLogicInventoryTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryNoticeOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryNoticeOrderQueryService")
public class CsDeliveryNoticeOrderQueryServiceImpl
implements ICsDeliveryNoticeOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryNoticeOrderQueryServiceImpl.class);
    @Resource
    private CsDeliveryNoticeOrderMapper csDeliveryNoticeOrderMapper;
    @Resource
    private CsDeliveryNoticeOrderDetailMapper csDeliveryNoticeOrderDetailMapper;
    @Resource
    private CsDeliveryResultOrderMapper csDeliveryResultOrderMapper;
    @Resource
    private CsLogicInventoryTotalMapper csLogicInventoryTotalMapper;
    @Resource
    private CsCommonService csCommonService;

    @Override
    public CsDeliveryNoticeOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (CsDeliveryNoticeOrderEo)this.csDeliveryNoticeOrderMapper.selectById((Serializable)id);
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryById(Long id) {
        List resultOrderEoList;
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsDeliveryNoticeOrderEo deliveryNoticeOrderEo = (CsDeliveryNoticeOrderEo)this.csDeliveryNoticeOrderMapper.selectById((Serializable)id);
        AssertUtil.isTrue(deliveryNoticeOrderEo != null && deliveryNoticeOrderEo.getId() != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        List detailEoList = this.csDeliveryNoticeOrderDetailMapper.queryByDocumentNo(deliveryNoticeOrderEo.getDocumentNo());
        CsDeliveryNoticeOrderRespDto dto = new CsDeliveryNoticeOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)deliveryNoticeOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList deliveryNoticeOrderDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)deliveryNoticeOrderDetailRespDtoList, (Collection)detailEoList, CsDeliveryNoticeOrderDetailRespDto.class);
            dto.setDeliveryNoticeOrderDetailRespDtoList((List)deliveryNoticeOrderDetailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)deliveryNoticeOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)deliveryNoticeOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(resultOrderEoList = this.csDeliveryResultOrderMapper.queryByRelevanceNo(deliveryNoticeOrderEo.getDocumentNo())))) {
            List resultNo = resultOrderEoList.stream().map(CsDeliveryResultOrderEo::getDocumentNo).collect(Collectors.toList());
            dto.setResultNo(resultNo);
        }
        return dto;
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryByDocumentNo(String documentNo) {
        List list = this.csDeliveryNoticeOrderMapper.queryByDocumentNo(documentNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        return this.queryById(((CsDeliveryNoticeOrderEo)list.get(0)).getId());
    }

    @Override
    public PageInfo<CsDeliveryNoticeOrderRespDto> queryByPage(CsDeliveryNoticeOrderQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        Long organizationId = this.csCommonService.getUserOrganizationId();
        if (null != organizationId) {
            wrapper.eq((Object)"organization_id", (Object)organizationId);
        }
        if (StringUtil.isNotBlank((String)queryDto.getBusinessType())) {
            wrapper.eq((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getOrderStatus())) {
            wrapper.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getPreOrderNo())) {
            wrapper.eq((Object)"pre_order_no", (Object)queryDto.getPreOrderNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getDocumentNo())) {
            wrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        wrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.csDeliveryNoticeOrderMapper.selectList((Wrapper)wrapper);
        PageInfo selectPage = new PageInfo(list);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, CsDeliveryNoticeOrderRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryByPreOrderNo(String preOrderNo) {
        List list = this.csDeliveryNoticeOrderMapper.queryByPreOrderNo(preOrderNo);
        CsDeliveryNoticeOrderRespDto dto = new CsDeliveryNoticeOrderRespDto();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyProperties((Object)dto, list.get(0), (String[])new String[0]);
        }
        return dto;
    }

    @Override
    public List<CsLogicInventoryTotalEo> queryWarehouseInventory(String warehouseCode, List<String> cargoList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        wrapper.in((Object)"cargo_code", cargoList);
        wrapper.eq((Object)"dr", (Object)0);
        List logicInventoryTotalEos = this.csLogicInventoryTotalMapper.selectList((Wrapper)wrapper);
        return logicInventoryTotalEos;
    }

    @Override
    public List<String> queryPreOrderNoIsBatch(List<String> preOrderNoList) {
        List<CsDeliveryNoticeOrderDetailEo> detailEoList = this.queryByPreOrderNoList(preOrderNoList);
        if (CollectionUtils.isNotEmpty(detailEoList)) {
            List<String> list = detailEoList.stream().map(CsDeliveryNoticeOrderDetailEo::getPreOrderNo).distinct().collect(Collectors.toList());
            return list;
        }
        return null;
    }

    private List<CsDeliveryNoticeOrderDetailEo> queryByPreOrderNoList(List<String> preOrderNoList) {
        CsDeliveryNoticeOrderDetailEo detailEo = new CsDeliveryNoticeOrderDetailEo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"pre_order_no", preOrderNoList);
        queryWrapper.isNull((Object)"batch");
        return this.csDeliveryNoticeOrderDetailMapper.selectList((Wrapper)queryWrapper);
    }
}

