/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.warehouse.CsLogicWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.warehouse.CsWarehouseAddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsWarehouseAddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csLogicWarehouseQueryService")
public class CsLogicWarehouseQueryServiceImpl
implements ICsLogicWarehouseQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseQueryServiceImpl.class);
    @Resource
    private CsLogicWarehouseDas csLogicWarehouseDas;
    @Resource
    private CsLogicWarehouseMapper csLogicWarehouseMapper;
    @Resource
    private CsWarehouseAddressDas csWarehouseAddressDas;
    @Resource
    private CsCommonService csCommonService;

    @Override
    public CsLogicWarehouseRespDto selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)this.csLogicWarehouseDas.selectByPrimaryKey(id);
        CsLogicWarehouseRespDto warehouseRespDto = new CsLogicWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)warehouseRespDto, (Object)csLogicWarehouseEo, (String[])new String[0]);
        if (null != csLogicWarehouseEo || null != csLogicWarehouseEo.getId()) {
            CsWarehouseAddressEo csWarehouseAddressEo = new CsWarehouseAddressEo();
            csWarehouseAddressEo.setWarehouseId(id);
            csWarehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            List warehouseAddressEos = this.csWarehouseAddressDas.select((BaseEo)csWarehouseAddressEo);
            if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEos)) {
                CsWarehouseAddressRespDto warehouseAddressRespDto = new CsWarehouseAddressRespDto();
                CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, warehouseAddressEos.get(0), (String[])new String[0]);
                warehouseRespDto.setWarehouseAddress(warehouseAddressRespDto);
            }
        }
        return warehouseRespDto;
    }

    @Override
    public PageInfo<CsLogicWarehouseRespDto> queryByPage(CsLogicWarehouseQueryDto queryDto) {
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        CsLogicWarehouseEo csLogicWarehouseEo = new CsLogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)csLogicWarehouseEo);
        Long orgId = this.csCommonService.getUserOrganizationId();
        if (Objects.nonNull(queryDto.getOrganizationId()) || Objects.nonNull(orgId)) {
            csLogicWarehouseEo.setOrganizationId(Objects.nonNull(queryDto.getOrganizationId()) ? queryDto.getOrganizationId() : orgId);
        }
        csLogicWarehouseEo.setOrderByDesc(queryDto.getOrderByDesc());
        PageInfo selectPage = this.csLogicWarehouseDas.selectPage((BaseEo)csLogicWarehouseEo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)selectPage.getList(), dtoList, CsLogicWarehouseRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List warehouseIds = dtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            CsWarehouseAddressEo csWarehouseAddressEo = new CsWarehouseAddressEo();
            csWarehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            csWarehouseAddressEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"warehouse_id", warehouseIds)));
            List warehouseAddressEos = this.csWarehouseAddressDas.select((BaseEo)csWarehouseAddressEo);
            if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEos)) {
                Map<Long, CsWarehouseAddressEo> addressEoMap = warehouseAddressEos.stream().collect(Collectors.toMap(CsWarehouseAddressEo::getWarehouseId, entity -> entity));
                for (CsLogicWarehouseRespDto warehouseRespDto : dtoList) {
                    CsWarehouseAddressRespDto warehouseAddressRespDto = new CsWarehouseAddressRespDto();
                    CsWarehouseAddressEo addressEo = addressEoMap.get(warehouseRespDto.getId());
                    CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, (Object)addressEo, (String[])new String[0]);
                    warehouseRespDto.setWarehouseAddress(warehouseAddressRespDto);
                }
            }
        }
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public List<CsLogicWarehouseRespDto> queryByParam(CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        QueryWrapper wrapper = new QueryWrapper();
        Long orgId = this.csCommonService.getUserOrganizationId();
        if (Objects.nonNull(queryDto.getOrganizationId()) || Objects.nonNull(orgId)) {
            wrapper.eq((Object)"organization_id", (Object)(Objects.nonNull(queryDto.getOrganizationId()) ? queryDto.getOrganizationId() : orgId));
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (queryDto.getMainWarehouse() != null) {
            wrapper.eq((Object)"main_warehouse", (Object)queryDto.getMainWarehouse());
        }
        if (queryDto.getWarehouseType() != null) {
            wrapper.eq((Object)"warehouse_type", (Object)queryDto.getWarehouseType());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        List selectList = this.csLogicWarehouseMapper.selectList((Wrapper)wrapper);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)selectList, CsLogicWarehouseRespDto.class);
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    @Override
    public PageInfo<WarehouseRespDto> queryByPage(WarehouseQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u903b\u8f91\u5e93\u5b58\uff08\u66ff\u4ee3bundle-base-center-inventory\u5de5\u7a0b\u540c\u540d\u65b9\u6cd5\uff09");
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)reqDto));
        QueryWrapper wrapper = new QueryWrapper();
        if (Objects.nonNull(reqDto.getId())) {
            wrapper.eq((Object)"warehouse_id", (Object)reqDto.getId());
        }
        if (Objects.nonNull(reqDto.getMainWarehouse())) {
            wrapper.eq((Object)"main_warehouse", (Object)reqDto.getMainWarehouse());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCode())) {
            wrapper.likeRight((Object)"warehouse_code", (Object)reqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            wrapper.likeRight((Object)"warehouse_name", (Object)reqDto.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateTimeStart())) {
            wrapper.ge((Object)"update_time", (Object)reqDto.getUpdateTimeStart());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateTimeEnd())) {
            wrapper.le((Object)"update_time", (Object)reqDto.getUpdateTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getType())) {
            wrapper.eq((Object)"warehouse_type", (Object)reqDto.getType());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getTypes())) {
            wrapper.in((Object)"warehouse_type", (Collection)reqDto.getTypes());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getCodes())) {
            wrapper.in((Object)"warehouse_code", (Collection)reqDto.getCodes());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getIds())) {
            wrapper.in((Object)"warehouse_id", (Collection)reqDto.getIds());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getOrganizationIds())) {
            wrapper.in((Object)"organization_id", (Collection)reqDto.getOrganizationIds());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"update_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.csLogicWarehouseMapper.selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)pageInfo, (String[])new String[]{"list"});
        List list = info.getList().stream().map(eo -> {
            WarehouseRespDto respDto = new WarehouseRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)respDto);
            respDto.setCode(eo.getWarehouseCode());
            respDto.setName(eo.getWarehouseName());
            respDto.setType(eo.getWarehouseType());
            return respDto;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public List<CsLogicWarehouseEo> queryByWarehouseCodes(List<String> warehouseCodes) {
        QueryWrapper wrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            wrapper.in((Object)"warehouse_code", warehouseCodes);
        }
        List selectList = this.csLogicWarehouseMapper.selectList((Wrapper)wrapper);
        return selectList;
    }
}

