/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="generateCodeUtils")
public class GenerateCodeUtils {
    static Logger logger = LoggerFactory.getLogger(GenerateCodeUtils.class);
    public static final String GENERATE_CODE_PREFIX = "Cs";
    public static final String GENERATE_CODE_SUFFIX = "ServiceImpl";
    public static final String COMMON = "Common";
    public static final String DELIVERY_NOTICE_ORDER = "DeliveryNoticeOrder";
    public static final String OUT_NOTICE_ORDER = "OutNoticeOrder";
    public static final String OUT_RESULT_ORDER = "OutResultOrder";
    public static final String DELIVERY_RESULT_ORDER = "DeliveryResultOrder";
    public static final String RECEIVE_NOTICE_ORDER = "ReceiveNoticeOrder";
    public static final String IN_NOTICE_ORDER = "InNoticeOrder";
    public static final String IN_RESULT_ORDER = "InResultOrder";
    public static final String RECEIVE_RESULT_ORDE = "ReceiveResultOrder";
    public static final String PHYSICS_WAREHOUSE = "PhysicsWarehouse";
    public static final String LOGIC_WAREHOUSE = "LogicWarehouse";
    public static final String VIRTUAL_WAREHOUSE = "VirtualWarehouse";
    public static final String CHANNEL_WAREHOUSE = "ChannelWarehouse";
    @Autowired
    private List<IGenerateCodeService> generateCodeServiceList;
    private static Map<String, IGenerateCodeService> generateCodeServiceMap = Maps.newConcurrentMap();

    @PostConstruct
    public void initStrategy() {
        generateCodeServiceMap = this.generateCodeServiceList.stream().collect(Collectors.toMap(IGenerateCodeService::getGenerateCodeStrategy, Function.identity()));
    }

    public static IGenerateCodeService getStrategy(String generateCodeStrategy) {
        logger.info("getStrategy==>\u83b7\u53d6\u751f\u6210\u7f16\u7801\u7b56\u7565\u7c7b,generateCodeStrategy:{}", (Object)generateCodeStrategy);
        if (StringUtils.isBlank((CharSequence)generateCodeStrategy)) {
            return generateCodeServiceMap.get(CsGenerateCodeStrategyEnum.COMMON.getCode());
        }
        CsGenerateCodeStrategyEnum generateCodeStrategyEnum = CsGenerateCodeStrategyEnum.getByCode((String)generateCodeStrategy);
        if (null == generateCodeStrategyEnum) {
            throw new BizException(String.format("\u3010%s\u3011\u7f16\u7801\u751f\u6210\u7b56\u7565\u6709\u8bef", generateCodeStrategy));
        }
        return generateCodeServiceMap.get(generateCodeStrategyEnum.getCode());
    }
}

