/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.CsInventorySourceTypeHandleUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryCheckService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.log.CsInventoryLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.log.CsInventoryOperateLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsInventoryPreemptionEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsInventoryLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsInventoryOperateLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsInventoryPreemptionMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.CsInventoryBasicConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryOperateLogTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCsInventoryService
implements ICsInventoryBasicsService,
ICsInventoryCheckService<CsInventoryInOutBasicsDto>,
ICsInventoryBasicsOperateService {
    Logger logger = LoggerFactory.getLogger(AbstractCsInventoryService.class);
    private final String LOCK_TABLE_NAME_PREFIX = "CS";
    private final String LOCK_TABLE_NAME_SUFFIX = "INVENTORY";
    @Autowired
    private CsInventoryLogDas inventoryLogDas;
    @Autowired
    protected ILockService lockService;
    @Autowired
    private IContext context;
    @Resource
    private CargoMapper cargoMapper;
    @Resource
    private CsInventoryPreemptionMapper csInventoryPreemptionMapper;
    @Resource
    private CsInventorySourceTypeHandleUtils csInventorySourceTypeHandleUtils;
    @Autowired
    private CsInventoryOperateLogDas operateLogDas;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.COMMON.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inInventory(CsInventoryInOutBasicsDto inParamDto) {
        this.logger.info("inInventory==>\u5165\u5e93,inParamDto:{}", (Object)LogUtils.buildLogContent(inParamDto));
        AssertUtil.isTrue(null != inParamDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inParamDto.getInOutBasicsCargoDtoList()), "\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        this.doPreProcessor(inParamDto);
        this.checkParam(inParamDto);
        this.sortList(inParamDto);
        inParamDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        Boolean inFlag = false;
        List inDetailDtoList = inParamDto.getInOutBasicsCargoDtoList();
        ArrayList successList = Lists.newArrayList();
        for (CsInventoryInOutBasicsCargoDto inDetailDto : inDetailDtoList) {
            Boolean inventoryFlag = this.doInInventory(inParamDto, inDetailDto);
            Boolean logFlag = this.doInsertInventoryLog(inParamDto, inDetailDto);
            if (!logFlag.booleanValue() || !inventoryFlag.booleanValue()) continue;
            successList.add(inDetailDto);
        }
        this.doSourceTypeHandle(inParamDto, successList);
        this.doPostProcessor(inParamDto, successList);
        inFlag = CollectionUtils.isNotEmpty((Collection)successList);
        return inFlag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean outInventory(CsInventoryInOutBasicsDto outParamDto) {
        this.logger.info("outInventory==>\u51fa\u5e93,outParamDto:{}", (Object)LogUtils.buildLogContent(outParamDto));
        AssertUtil.isTrue(null != outParamDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)outParamDto.getInOutBasicsCargoDtoList()), "\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        this.doPreProcessor(outParamDto);
        this.checkParam(outParamDto);
        this.sortList(outParamDto);
        outParamDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        Boolean inFlag = false;
        List inDetailDtoList = outParamDto.getInOutBasicsCargoDtoList();
        ArrayList successList = Lists.newArrayList();
        for (CsInventoryInOutBasicsCargoDto inDetailDto : inDetailDtoList) {
            Boolean inventoryFlag = this.doOutInventory(outParamDto, inDetailDto);
            Boolean logFlag = this.doInsertInventoryLog(outParamDto, inDetailDto);
            if (!logFlag.booleanValue() || !inventoryFlag.booleanValue()) continue;
            successList.add(inDetailDto);
        }
        this.doSourceTypeHandle(outParamDto, successList);
        this.doPostProcessor(outParamDto, successList);
        inFlag = CollectionUtils.isNotEmpty((Collection)successList);
        return inFlag;
    }

    protected void doSourceTypeHandle(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        this.csInventorySourceTypeHandleUtils.doHandler(inParamDto, successList);
    }

    protected void doPostProcessor(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        this.updatePreemptionInfoDisable(inParamDto, successList);
    }

    private void updatePreemptionInfoDisable(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        if (CollectionUtils.isEmpty(successList)) {
            return;
        }
        String sourceType = inParamDto.getSourceType();
        ArrayList releaseSourceTypeStrList = Lists.newArrayList();
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_BUSINESS_APPROVE_RELEASE.getCode());
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_FINANCE_APPROVE_RELEASE.getCode());
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_ORDER_CATCH_RELEASE.getCode());
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_ACT_AUDIT_RELEASE.getCode());
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_ACT_CANCEL_PREEMPT.getCode());
        releaseSourceTypeStrList.add(CsInventorySourceTypeEnum.IN_ACT_FINISH_BACKTRACK.getCode());
        if (!releaseSourceTypeStrList.contains(sourceType)) {
            return;
        }
        String sourceNo = inParamDto.getSourceNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        ArrayList sourceTypeList = Lists.newArrayList();
        sourceTypeList.add(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        sourceTypeList.add(CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT.getCode());
        sourceTypeList.add(CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode());
        sourceTypeList.add(CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT.getCode());
        queryWrapper.in((Object)"source_type", (Collection)sourceTypeList);
        String strategy = this.getStrategy();
        if (CsInventoryStrategyEnum.ACTIVITY.getCode().equals(strategy)) {
            queryWrapper.in((Object)"activity_flag", new Object[]{YesNoEnum.YES.getValue()});
        } else {
            queryWrapper.in((Object)"activity_flag", new Object[]{YesNoEnum.NO.getValue()});
        }
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        this.logger.info("updatePreemptionInfoDisable==>queryWrapper:{}", (Object)LogUtils.buildLogContent(queryWrapper));
        List csInventoryPreemptionEoList = this.csInventoryPreemptionMapper.selectList((Wrapper)queryWrapper);
        this.logger.info("updatePreemptionInfoDisable==>csInventoryPreemptionEoList:{}", (Object)LogUtils.buildLogContent(csInventoryPreemptionEoList));
        if (CollectionUtils.isEmpty((Collection)csInventoryPreemptionEoList)) {
            this.logger.error("updatePreemptionInfoDisable==>\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55,sourceNo:{}", (Object)sourceNo);
            return;
        }
        List idList = csInventoryPreemptionEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        CsInventoryPreemptionEo updateEo = new CsInventoryPreemptionEo();
        updateEo.setValid(CsValidFlagEnum.DISABLE.getCode());
        updateEo.setDisplay(YesNoEnum.NO.getValue());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", idList);
        this.logger.info("updatePreemptionInfoDisable==>\u9884\u5360\u8bb0\u5f55\u5373\u5c06\u6279\u91cf\u7f6e\u4e3a\u65e0\u6548,updateEo:{},updateWrapper:{}", (Object)LogUtils.buildLogContent(updateEo), (Object)LogUtils.buildLogContent(updateWrapper));
        this.csInventoryPreemptionMapper.update((Object)updateEo, (Wrapper)updateWrapper);
    }

    protected void doPreProcessor(CsInventoryInOutBasicsDto inParamDto) {
        if (null == inParamDto) {
            return;
        }
        List inOutBasicsCargoDtoList = inParamDto.getInOutBasicsCargoDtoList();
        if (CollectionUtils.isEmpty((Collection)inOutBasicsCargoDtoList)) {
            return;
        }
        inOutBasicsCargoDtoList.forEach(dto -> dto.setActivityFlag(YesNoEnum.NO.getValue()));
    }

    protected void sortList(CsInventoryInOutBasicsDto inParamDto) {
    }

    private Boolean doInInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        return this.doExecuteInventory(inParamDto, inDetailDto);
    }

    protected Boolean doOutInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        this.logger.info("doOutInventory==>\u5373\u5c06\u6267\u884c\u51fa\u5e93\u64cd\u4f5c,inParamDto:{},inDetailDto:{}");
        return this.doExecuteInventory(inParamDto, inDetailDto);
    }

    protected Boolean doExecuteInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        Long inventoryId = this.existInventory(inParamDto, inDetailDto);
        boolean result = false;
        result = null == inventoryId ? this.doInitInventory(inParamDto, inDetailDto).booleanValue() : this.doUpdateInventory(inventoryId, inParamDto, inDetailDto);
        if (!result) {
            this.logger.error("\u51fa\u5165\u5e93\u5e93\u5b58\u64cd\u4f5c\u5f02\u5e38,inParamDto:{},inDetailDto:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(inDetailDto));
            String batch = "";
            if (StringUtils.isNotBlank((CharSequence)inDetailDto.getBatch())) {
                batch = "\u6279\u6b21\u53f7\uff1a[" + inDetailDto.getBatch() + "]";
            }
            String ex = "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4ed3\u5e93\uff1a[" + inDetailDto.getWarehouseCode() + "]\u8d27\u54c1\u7f16\u7801\uff1a[" + inDetailDto.getCargoCode() + "]" + batch;
            throw new CsInventoryException(CsInventoryExceptionCode.INVENTORY_EXCEPTION.getCode(), ex);
        }
        return result;
    }

    protected Mutex lock(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String lockTableName = this.getLockTableName();
        String lockKey = this.inventoryLockKey(inParamDto, inDetailDto);
        this.logger.info("lock==>lockTableName:{},lockKey:{}", (Object)lockTableName, (Object)lockKey);
        Mutex mutex = this.lockService.lock(lockTableName, lockKey, this.inventoryLockTimeOut().intValue());
        if (null == mutex) {
            throw new CsInventoryException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25~");
        }
        return mutex;
    }

    protected void unLock(Mutex mutex) {
        this.lockService.unlock(mutex);
    }

    protected Integer inventoryLockTimeOut() {
        return CsInventoryBasicConstant.DEFAULT_LOCK_TIME_OUT;
    }

    protected String inventoryLockKey(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        if (StringUtils.isNotBlank((CharSequence)batch)) {
            return String.format("%s_%s_%s", inDetailDto.getWarehouseId(), inDetailDto.getCargoId(), inDetailDto.getBatch());
        }
        return String.format("%s_%s", inDetailDto.getWarehouseId(), inDetailDto.getCargoId());
    }

    private String getLockTableName() {
        String strategy = this.getStrategy();
        strategy = StringUtils.isBlank((CharSequence)strategy) ? CsInventoryStrategyEnum.COMMON.getCode() : strategy;
        return String.format("%s_%s_%s", "CS", strategy, "INVENTORY");
    }

    protected Boolean doInsertInventoryLog(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        this.logger.info("insertInventoryLog==>\u5373\u5c06\u63d2\u5165\u5e93\u5b58\u65e5\u5fd7\u6d41\u6c34,inOutBasicDto:{},basicDetailDto:{}", (Object)LogUtils.buildLogContent(inOutBasicDto), (Object)LogUtils.buildLogContent(basicDetailDto));
        String batch = basicDetailDto.getBatch();
        CsInventoryLogEo csInventoryLogEo = new CsInventoryLogEo();
        csInventoryLogEo.setId(IdUtils.getId());
        csInventoryLogEo.setVersion(IdUtils.getId() + "");
        csInventoryLogEo.setWarehouseId(basicDetailDto.getWarehouseId());
        csInventoryLogEo.setWarehouseCode(basicDetailDto.getWarehouseCode());
        csInventoryLogEo.setWarehouseName(basicDetailDto.getWarehouseName());
        csInventoryLogEo.setWarehouseClassify(basicDetailDto.getWarehouseClassify());
        csInventoryLogEo.setWarehouseType(basicDetailDto.getWarehouseType());
        csInventoryLogEo.setCargoId(basicDetailDto.getCargoId());
        csInventoryLogEo.setCargoCode(basicDetailDto.getCargoCode());
        csInventoryLogEo.setCargoName(basicDetailDto.getCargoName());
        csInventoryLogEo.setArtNo(basicDetailDto.getArtNo());
        csInventoryLogEo.setBatch(basicDetailDto.getBatch());
        csInventoryLogEo.setBatchType(basicDetailDto.getBatchType());
        csInventoryLogEo.setIsGift(basicDetailDto.getIsGift());
        csInventoryLogEo.setChangeBalance(basicDetailDto.getBalance());
        csInventoryLogEo.setChangePreempt(basicDetailDto.getPreempt());
        csInventoryLogEo.setChangeAllocate(basicDetailDto.getAllocate());
        csInventoryLogEo.setChangeActivityAllocate(basicDetailDto.getActivityAllocate());
        csInventoryLogEo.setChangeIntransit(basicDetailDto.getIntransit());
        csInventoryLogEo.setChangeTransfer(basicDetailDto.getTransfer());
        csInventoryLogEo.setChangeCompleted(basicDetailDto.getCompleted());
        csInventoryLogEo.setChangeAvailable(this.calculateChangeAvailableInventory(inOutBasicDto, basicDetailDto));
        csInventoryLogEo.setSourceType(inOutBasicDto.getSourceType());
        csInventoryLogEo.setSourceNo(inOutBasicDto.getSourceNo());
        csInventoryLogEo.setRemark(inOutBasicDto.getRemark());
        csInventoryLogEo.setUpdateTime(new Date());
        csInventoryLogEo.setCreateTime(new Date());
        csInventoryLogEo.setChangeTime(csInventoryLogEo.getCreateTime());
        csInventoryLogEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        csInventoryLogEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        csInventoryLogEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csInventoryLogEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csInventoryLogEo.setInOutFlag(inOutBasicDto.getInOutFlag());
        String sourceTableName = this.getInventoryLogTableName(inOutBasicDto, basicDetailDto);
        csInventoryLogEo.setSourceTableName(sourceTableName);
        this.logger.info("insertInventoryLog==>\u5373\u5c06\u63d2\u5165\u5e93\u5b58\u65e5\u5fd7\u6d41\u6c34,sourceNo:{},csInventoryLogEo:{}", (Object)inOutBasicDto.getSourceNo(), (Object)LogUtils.buildLogContent(csInventoryLogEo));
        int result = this.inventoryLogDas.insertLog(csInventoryLogEo);
        if (StringUtils.isNotBlank((CharSequence)csInventoryLogEo.getBatch()) && YesNoEnum.YES.getValue().equals(inOutBasicDto.getUpdateTotalFlag())) {
            basicDetailDto.setBatch(null);
            sourceTableName = this.getInventoryLogTableName(inOutBasicDto, basicDetailDto);
            csInventoryLogEo.setSourceTableName(sourceTableName);
            csInventoryLogEo.setBatch(null);
            csInventoryLogEo.setId(IdUtils.getId());
            this.logger.info("insertInventoryLog==>\u5373\u5c06\u63d2\u5165\u5e93\u5b58\u65e5\u5fd7\u6d41\u6c34,sourceNo:{},csInventoryLogEo:{}", (Object)inOutBasicDto.getSourceNo(), (Object)LogUtils.buildLogContent(csInventoryLogEo));
            this.inventoryLogDas.insertLog(csInventoryLogEo);
        }
        basicDetailDto.setBatch(batch);
        if (result <= 0) {
            throw new BizException("\u63d2\u5165\u5e93\u5b58\u65e5\u5fd7\u6d41\u6c34\u5f02\u5e38");
        }
        Boolean operateLog = this.doInsertInventoryOperateLog(inOutBasicDto, basicDetailDto);
        if (!operateLog.booleanValue()) {
            throw new BizException("\u63d2\u5165\u5e93\u5b58\u64cd\u4f5c\u6d41\u6c34\u5f02\u5e38");
        }
        return true;
    }

    private Boolean doInsertInventoryOperateLog(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        this.logger.info("doInsertInventoryOperateLog==>\u5e93\u5b58\u64cd\u4f5c\u6d41\u6c34\u8868,inOutBasicDto:{},basicDetailDto:{}", (Object)LogUtils.buildLogContent(inOutBasicDto), (Object)LogUtils.buildLogContent(basicDetailDto));
        String batch = basicDetailDto.getBatch();
        CsInventoryOperateLogEo csInventoryOperateLogEo = new CsInventoryOperateLogEo();
        csInventoryOperateLogEo.setId(IdUtils.getId());
        csInventoryOperateLogEo.setVersion(IdUtils.getId() + "");
        csInventoryOperateLogEo.setWarehouseId(basicDetailDto.getWarehouseId());
        csInventoryOperateLogEo.setWarehouseCode(basicDetailDto.getWarehouseCode());
        csInventoryOperateLogEo.setWarehouseName(basicDetailDto.getWarehouseName());
        csInventoryOperateLogEo.setWarehouseClassify(basicDetailDto.getWarehouseClassify());
        csInventoryOperateLogEo.setWarehouseType(basicDetailDto.getWarehouseType());
        csInventoryOperateLogEo.setCargoId(basicDetailDto.getCargoId());
        csInventoryOperateLogEo.setCargoCode(basicDetailDto.getCargoCode());
        csInventoryOperateLogEo.setCargoName(basicDetailDto.getCargoName());
        csInventoryOperateLogEo.setArtNo(basicDetailDto.getArtNo());
        csInventoryOperateLogEo.setBatch(basicDetailDto.getBatch());
        csInventoryOperateLogEo.setBatchType(basicDetailDto.getBatchType());
        csInventoryOperateLogEo.setSourceType(inOutBasicDto.getSourceType());
        csInventoryOperateLogEo.setSourceNo(inOutBasicDto.getSourceNo());
        csInventoryOperateLogEo.setRemark(inOutBasicDto.getRemark());
        csInventoryOperateLogEo.setUpdateTime(new Date());
        csInventoryOperateLogEo.setCreateTime(new Date());
        csInventoryOperateLogEo.setChangeTime(csInventoryOperateLogEo.getCreateTime());
        csInventoryOperateLogEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        csInventoryOperateLogEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        csInventoryOperateLogEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csInventoryOperateLogEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csInventoryOperateLogEo.setInOutFlag(inOutBasicDto.getInOutFlag());
        String sourceTableName = this.getInventoryLogTableName(inOutBasicDto, basicDetailDto);
        csInventoryOperateLogEo.setSourceTableName(sourceTableName);
        this.logger.info("doInsertInventoryOperateLog==>\u5373\u5c06\u63d2\u5165\u5e93\u5b58\u64cd\u4f5c\u6d41\u6c34,sourceNo:{},csInventoryOperateLogEo:{}", (Object)inOutBasicDto.getSourceNo(), (Object)LogUtils.buildLogContent(csInventoryOperateLogEo));
        ArrayList csInventoryOperateLogEoList = Lists.newArrayList();
        this.buildOperateLogEoList(csInventoryOperateLogEo, csInventoryOperateLogEoList, inOutBasicDto, basicDetailDto);
        this.logger.info("doInsertInventoryOperateLog==>\u6574\u7406\u540e\u7684\u64cd\u4f5cEO\u96c6\u5408,csInventoryOperateLogEoList:{}", (Object)LogUtils.buildLogContent(csInventoryOperateLogEoList));
        if (CollectionUtils.isEmpty((Collection)csInventoryOperateLogEoList)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)csInventoryOperateLogEo.getBatch()) && YesNoEnum.YES.getValue().equals(inOutBasicDto.getUpdateTotalFlag())) {
            basicDetailDto.setBatch(null);
            sourceTableName = this.getInventoryLogTableName(inOutBasicDto, basicDetailDto);
            ListIterator<CsInventoryOperateLogEo> iterator = csInventoryOperateLogEoList.listIterator();
            while (iterator.hasNext()) {
                CsInventoryOperateLogEo tempEo = (CsInventoryOperateLogEo)iterator.next();
                CsInventoryOperateLogEo totalUpdateEo = new CsInventoryOperateLogEo();
                CubeBeanUtils.copyProperties((Object)totalUpdateEo, (Object)tempEo, (String[])new String[0]);
                totalUpdateEo.setId(IdUtils.getId());
                totalUpdateEo.setVersion(IdUtils.getId() + "");
                totalUpdateEo.setBatch(null);
                totalUpdateEo.setSourceTableName(sourceTableName);
                iterator.add(totalUpdateEo);
            }
        }
        Collections.sort(csInventoryOperateLogEoList, Comparator.comparing(BaseEo::getId));
        for (CsInventoryOperateLogEo updateEo : csInventoryOperateLogEoList) {
            int result = this.operateLogDas.insertLog(updateEo);
            if (result > 0) continue;
            return false;
        }
        basicDetailDto.setBatch(batch);
        return true;
    }

    private void buildOperateLogEoList(CsInventoryOperateLogEo csInventoryOperateLogEo, List<CsInventoryOperateLogEo> csInventoryOperateLogEoList, CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        BigDecimal changeAvailableInventory;
        BigDecimal completed;
        BigDecimal transfer;
        BigDecimal intransit;
        BigDecimal activityAllocate;
        BigDecimal allocate;
        BigDecimal preempt;
        BigDecimal balance = basicDetailDto.getBalance();
        if (null != balance) {
            CsInventoryOperateLogEo balanceEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)balanceEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            balanceEo.setId(IdUtils.getId());
            balanceEo.setVersion(IdUtils.getId() + "");
            balanceEo.setChangeType(CsInventoryOperateLogTypeEnum.BALANCE.getCode());
            balanceEo.setChangeInventory(balance);
            csInventoryOperateLogEoList.add(balanceEo);
        }
        if (null != (preempt = basicDetailDto.getPreempt())) {
            CsInventoryOperateLogEo preemptEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)preemptEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            preemptEo.setId(IdUtils.getId());
            preemptEo.setVersion(IdUtils.getId() + "");
            preemptEo.setChangeType(CsInventoryOperateLogTypeEnum.PREEMPT.getCode());
            preemptEo.setChangeInventory(preempt);
            csInventoryOperateLogEoList.add(preemptEo);
        }
        if (null != (allocate = basicDetailDto.getAllocate())) {
            CsInventoryOperateLogEo allocateEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)allocateEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            allocateEo.setId(IdUtils.getId());
            allocateEo.setVersion(IdUtils.getId() + "");
            allocateEo.setChangeType(CsInventoryOperateLogTypeEnum.ALLOCATE.getCode());
            allocateEo.setChangeInventory(allocate);
            csInventoryOperateLogEoList.add(allocateEo);
        }
        if (null != (activityAllocate = basicDetailDto.getActivityAllocate())) {
            CsInventoryOperateLogEo activityAllocateEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)activityAllocateEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            activityAllocateEo.setId(IdUtils.getId());
            activityAllocateEo.setVersion(IdUtils.getId() + "");
            activityAllocateEo.setChangeType(CsInventoryOperateLogTypeEnum.ACTIVITY_ALLOCATE.getCode());
            activityAllocateEo.setChangeInventory(activityAllocate);
            csInventoryOperateLogEoList.add(activityAllocateEo);
        }
        if (null != (intransit = basicDetailDto.getIntransit())) {
            CsInventoryOperateLogEo intransitEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)intransitEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            intransitEo.setId(IdUtils.getId());
            intransitEo.setVersion(IdUtils.getId() + "");
            intransitEo.setChangeType(CsInventoryOperateLogTypeEnum.INTRANSIT.getCode());
            intransitEo.setChangeInventory(intransit);
            csInventoryOperateLogEoList.add(intransitEo);
        }
        if (null != (transfer = basicDetailDto.getTransfer())) {
            CsInventoryOperateLogEo transferEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)transferEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            transferEo.setId(IdUtils.getId());
            transferEo.setVersion(IdUtils.getId() + "");
            transferEo.setChangeType(CsInventoryOperateLogTypeEnum.TRANSFER.getCode());
            transferEo.setChangeInventory(transfer);
            csInventoryOperateLogEoList.add(transferEo);
        }
        if (null != (completed = basicDetailDto.getCompleted())) {
            CsInventoryOperateLogEo completedEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)completedEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            completedEo.setId(IdUtils.getId());
            completedEo.setVersion(IdUtils.getId() + "");
            completedEo.setChangeType(CsInventoryOperateLogTypeEnum.COMPLETED.getCode());
            completedEo.setChangeInventory(completed);
            csInventoryOperateLogEoList.add(completedEo);
        }
        if (null != (changeAvailableInventory = this.calculateChangeAvailableInventory(inOutBasicDto, basicDetailDto)) && changeAvailableInventory.compareTo(BigDecimal.ZERO) != 0) {
            CsInventoryOperateLogEo availableEo = new CsInventoryOperateLogEo();
            CubeBeanUtils.copyProperties((Object)availableEo, (Object)csInventoryOperateLogEo, (String[])new String[0]);
            availableEo.setId(IdUtils.getId());
            availableEo.setVersion(IdUtils.getId() + "");
            availableEo.setChangeType(CsInventoryOperateLogTypeEnum.AVAILABLE.getCode());
            availableEo.setChangeInventory(changeAvailableInventory);
            csInventoryOperateLogEoList.add(availableEo);
        }
    }

    protected BigDecimal calculateChangeAvailableInventory(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        this.logger.info("calculateChangeAvailableInventory==>\u8ba1\u7b97\u53d8\u52a8\u7684\u53ef\u7528\u5e93\u5b58,basicDetailDto:{}", (Object)LogUtils.buildLogContent(basicDetailDto));
        BigDecimal resultChangeAvailableInventory = BigDecimal.ZERO;
        Integer updateAvailableFlag = inOutBasicDto.getUpdateAvailableFlag();
        if (null == updateAvailableFlag || YesNoEnum.NO.getValue().equals(updateAvailableFlag)) {
            return resultChangeAvailableInventory;
        }
        if (null == basicDetailDto) {
            return resultChangeAvailableInventory;
        }
        if (null != basicDetailDto.getPreempt()) {
            resultChangeAvailableInventory = resultChangeAvailableInventory.add(basicDetailDto.getPreempt());
        }
        if (null != basicDetailDto.getAllocate()) {
            resultChangeAvailableInventory = resultChangeAvailableInventory.add(basicDetailDto.getAllocate());
        }
        if (null != basicDetailDto.getTransfer()) {
            resultChangeAvailableInventory = resultChangeAvailableInventory.add(basicDetailDto.getTransfer());
        }
        if (null != basicDetailDto.getActivityAllocate()) {
            resultChangeAvailableInventory = resultChangeAvailableInventory.add(basicDetailDto.getActivityAllocate());
        }
        if (null != basicDetailDto.getIntransit()) {
            resultChangeAvailableInventory = resultChangeAvailableInventory.subtract(basicDetailDto.getIntransit());
        }
        if (null != basicDetailDto.getBalance()) {
            resultChangeAvailableInventory = resultChangeAvailableInventory.subtract(basicDetailDto.getBalance());
        }
        return resultChangeAvailableInventory;
    }

    protected BigDecimal calculateInsertAvailableInventory(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        this.logger.info("calculateChangeAvailableInventory==>\u8ba1\u7b97\u53d8\u52a8\u7684\u53ef\u7528\u5e93\u5b58,basicDetailDto:{}", (Object)LogUtils.buildLogContent(basicDetailDto));
        BigDecimal insertAvailableInventory = BigDecimal.ZERO;
        if (null != basicDetailDto.getBalance()) {
            insertAvailableInventory = insertAvailableInventory.add(basicDetailDto.getBalance());
        }
        if (null != basicDetailDto.getIntransit()) {
            insertAvailableInventory = insertAvailableInventory.add(basicDetailDto.getIntransit());
        }
        if (null != basicDetailDto.getPreempt()) {
            insertAvailableInventory = insertAvailableInventory.subtract(basicDetailDto.getPreempt());
        }
        if (null != basicDetailDto.getAllocate()) {
            insertAvailableInventory = insertAvailableInventory.subtract(basicDetailDto.getAllocate());
        }
        if (null != basicDetailDto.getTransfer()) {
            insertAvailableInventory = insertAvailableInventory.subtract(basicDetailDto.getTransfer());
        }
        if (null != basicDetailDto.getActivityAllocate()) {
            insertAvailableInventory = insertAvailableInventory.subtract(basicDetailDto.getActivityAllocate());
        }
        return insertAvailableInventory;
    }

    @Override
    public Boolean checkParam(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        AssertUtil.isTrue(null != csInventoryInOutBasicsDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryInOutBasicsDto.getStrategy()) && null != CsInventoryStrategyEnum.getByCode((String)csInventoryInOutBasicsDto.getStrategy()), "\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u7b56\u7565");
        Integer negativeValidate = csInventoryInOutBasicsDto.getNegativeValidate();
        if (null == negativeValidate) {
            negativeValidate = YesNoEnum.YES.getValue();
        }
        csInventoryInOutBasicsDto.setNegativeValidate(negativeValidate);
        String coverInventoryFlag = csInventoryInOutBasicsDto.getCoverInventoryFlag();
        if (StringUtils.isBlank((CharSequence)coverInventoryFlag)) {
            coverInventoryFlag = CsInventoryCoverInventoryFlagEnum.UPDATE.getCode();
            csInventoryInOutBasicsDto.setCoverInventoryFlag(coverInventoryFlag);
        } else {
            AssertUtil.isTrue(CsInventoryCoverInventoryFlagEnum.getByCode((String)coverInventoryFlag) != null, "\u5e93\u5b58\u662f\u5426\u8986\u76d6\u6807\u8bc6\u6709\u8bef");
            csInventoryInOutBasicsDto.setCoverInventoryFlag(coverInventoryFlag);
        }
        Integer updateTotalFlag = csInventoryInOutBasicsDto.getUpdateTotalFlag();
        if (null == updateTotalFlag) {
            csInventoryInOutBasicsDto.setUpdateTotalFlag(YesNoEnum.YES.getValue());
        } else {
            AssertUtil.isTrue(YesNoEnum.YES.getValue().equals(updateTotalFlag) || YesNoEnum.NO.getValue().equals(updateTotalFlag), "\u662f\u5426\u540c\u6b65\u66f4\u65b0\u603b\u8868\u6807\u8bc6\u6709\u8bef");
            csInventoryInOutBasicsDto.setUpdateTotalFlag(updateTotalFlag);
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryInOutBasicsDto.getSourceNo()), "\u6765\u6e90\u5355\u636e\u53f7\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryInOutBasicsDto.getSourceType()) && null != CsInventorySourceTypeEnum.getByCode((String)csInventoryInOutBasicsDto.getSourceType()), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        List inOutBasicDetailDtoList = csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inOutBasicDetailDtoList), "\u8d27\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        inOutBasicDetailDtoList.forEach(dto -> {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)dto.getCargoCode()), "\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        });
        List cargoCodeList = inOutBasicDetailDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getCargoCode).collect(Collectors.toList());
        QueryWrapper cargoEoQueryWrapper = new QueryWrapper();
        cargoEoQueryWrapper.in((Object)"code", cargoCodeList);
        List cargoEoList = this.cargoMapper.selectList((Wrapper)cargoEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)cargoEoList), "\u67e5\u8be2\u4e0d\u5230\u8d27\u54c1\u4fe1\u606f");
        Map cargoMap = cargoEoList.stream().collect(Collectors.toMap(StdCargoEo::getCode, Function.identity()));
        for (CsInventoryInOutBasicsCargoDto dto2 : inOutBasicDetailDtoList) {
            String cargoCode = dto2.getCargoCode();
            CargoEo cargoEo = (CargoEo)cargoMap.get(cargoCode);
            AssertUtil.isTrue(null != cargoEo, String.format("\u3010%s\u3011\u8d27\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8865\u5145\u540e\u5904\u7406", cargoCode));
            dto2.setCargoCode(cargoEo.getCode());
            dto2.setCargoId(cargoEo.getId());
            dto2.setCargoName(cargoEo.getName());
            dto2.setArtNo(cargoEo.getArtNo());
        }
        Boolean existWarehouse = this.existWarehouse(csInventoryInOutBasicsDto);
        AssertUtil.isTrue(existWarehouse, "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        csInventoryInOutBasicsDto.setStrategy(this.getStrategy());
        Collections.sort(inOutBasicDetailDtoList, Comparator.comparing(CsInventoryInOutBasicsCargoDto::getCargoId));
        return true;
    }

    @Override
    public Boolean existWarehouse(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        return true;
    }

    protected String getInventoryLogTableName(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        return null;
    }

    @Override
    public Long existInventory(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto, CsInventoryInOutBasicsCargoDto csInventoryInOutBasicsCargoDto) {
        return -1L;
    }

    @Override
    public Boolean doInitInventory(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto, CsInventoryInOutBasicsCargoDto csInventoryInOutBasicsCargoDto) {
        return true;
    }

    @Override
    public boolean doUpdateInventory(Long inventoryId, CsInventoryInOutBasicsDto csInventoryInOutBasicsDto, CsInventoryInOutBasicsCargoDto csInventoryInOutBasicsCargoDto) {
        return true;
    }
}

