/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csReceiveResultOrderApi")
public class CsReceiveResultOrderApiImpl
implements ICsReceiveResultOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveResultOrderApiImpl.class);
    @Autowired
    private ICsReceiveResultOrderService csReceiveResultOrderService;
    @Resource
    private ICsReceiveNoticeOrderService csReceiveNoticeOrderService;

    public RestResponse<Long> add(CsReceiveResultOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csReceiveResultOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsReceiveResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveResultOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveResultOrderService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> reCheckInInventory(TcbjReCheckReqDto reCheckReqDto) {
        logger.info("\u590d\u6838\u5165\u5e93\uff0c\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u5165\u53c2\uff1a[{}]", (Object)LogUtils.buildLogContent(reCheckReqDto));
        CsReceiveResultOrderAddReqDto addReqDto = this.changeParams(reCheckReqDto);
        Long addId = this.csReceiveResultOrderService.add(addReqDto);
        logger.info("\u590d\u6838\u5165\u5e93\uff0c\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\uff0cid\uff1a[{}]", (Object)addId);
        this.csReceiveNoticeOrderService.updateOrderStatus(reCheckReqDto.getRefundOrderNo(), CsDocumentActionEnum.REVERSE_AUDIT_PASS.getCode());
        logger.info("\u590d\u6838\u5165\u5e93\uff0c\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5b8c\u6210");
        CompletableFuture.runAsync(() -> {
            logger.info("\u590d\u6838\u5165\u5e93\uff08\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff09\uff0c\u5373\u5c06\u6574\u4f53\u64cd\u4f5c\u5165\u5e93reCheckInInventoryOverall===>preOrderNo:{}", (Object)addReqDto.getPreOrderNo());
            Boolean inInventoryFlag = this.csReceiveNoticeOrderService.reCheckInInventoryOverall(addReqDto);
            logger.info("\u590d\u6838\u5165\u5e93(\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f)\uff0c\u5373\u5c06\u6574\u4f53\u64cd\u4f5c\u5165\u5e93reCheckInInventoryOverall\uff0c\u8fd4\u56de\u7ed3\u679c,inInventoryFlag:{}", (Object)inInventoryFlag);
        });
        return new RestResponse();
    }

    private CsReceiveResultOrderAddReqDto changeParams(TcbjReCheckReqDto reCheckReqDto) {
        CsReceiveResultOrderAddReqDto addReqDto = new CsReceiveResultOrderAddReqDto();
        addReqDto.setPreOrderNo(reCheckReqDto.getRefundOrderNo());
        addReqDto.setExternalOrderNo(reCheckReqDto.getExternalOrderNo());
        addReqDto.setWarehouseCode(reCheckReqDto.getWarehouseCode());
        addReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_EXCHANGE_IN.getCode());
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)reCheckReqDto.getReCheckDetailReqDtoList()), "\u8d27\u54c1\u8be6\u60c5\u7f3a\u5931");
        for (TcbjReCheckDetailReqDto tcbjReCheckDetailReqDto : reCheckReqDto.getReCheckDetailReqDtoList()) {
            CsReceiveResultOrderDetailAddReqDto detailAddReqDto = new CsReceiveResultOrderDetailAddReqDto();
            CubeBeanUtils.copyProperties((Object)detailAddReqDto, (Object)tcbjReCheckDetailReqDto, (String[])new String[0]);
            detailAddReqDto.setQuantity(tcbjReCheckDetailReqDto.getRefundNum());
            detailAddReqDtoList.add(detailAddReqDto);
        }
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        return addReqDto;
    }

    public static void main(String[] args) {
        String a = "{\"reCheckDetailReqDtoList\":[{\"batch\":\"20230221N\",\"cargoCode\":\"A.A.01.01.AA010151BA\",\"refundNum\":36},{\"batch\":\"20230301D\",\"cargoCode\":\"A.A.01.01.AA010165C\",\"refundNum\":1},{\"batch\":\"20230203D\",\"cargoCode\":\"A.A.01.01.AA010174E\",\"refundNum\":81},{\"batch\":\"20230102D\",\"cargoCode\":\"A.A.01.01.AA010174E\",\"refundNum\":1},{\"batch\":\"20230308D\",\"cargoCode\":\"A.A.01.01.AA010174E\",\"refundNum\":17},{\"batch\":\"20230202D\",\"cargoCode\":\"A.A.01.04.AA010426B\",\"refundNum\":4},{\"batch\":\"20230302G\",\"cargoCode\":\"A.A.01.05.AA010520E\",\"refundNum\":17},{\"batch\":\"20230201G\",\"cargoCode\":\"A.A.01.05.AA010520E\",\"refundNum\":7},{\"batch\":\"20221202G\",\"cargoCode\":\"A.A.01.05.AA010520E\",\"refundNum\":2},{\"batch\":\"20230104G\",\"cargoCode\":\"A.A.01.07.AA010721F\",\"refundNum\":1},{\"batch\":\"20230202G\",\"cargoCode\":\"A.A.01.07.AA010721F\",\"refundNum\":38},{\"batch\":\"20230301G\",\"cargoCode\":\"A.A.01.07.AA010721F\",\"refundNum\":22},{\"batch\":\"20230115D\",\"cargoCode\":\"A.A.01.02.AA010210C\",\"refundNum\":3},{\"batch\":\"20221202D\",\"cargoCode\":\"A.A.01.02.AA010210C\",\"refundNum\":1},{\"batch\":\"20230305D\",\"cargoCode\":\"A.A.01.02.AA010210C\",\"refundNum\":1},{\"batch\":\"20230301G\",\"cargoCode\":\"A.A.01.07.AA010702\",\"refundNum\":1},{\"batch\":\"20221201A\",\"cargoCode\":\"A.A.01.01.AA010115B\",\"refundNum\":2},{\"batch\":\"20230202A\",\"cargoCode\":\"A.A.01.01.AA010115B\",\"refundNum\":7},{\"batch\":\"20230308G\",\"cargoCode\":\"A.A.01.03.AA010306\",\"refundNum\":215},{\"batch\":\"20230101D\",\"cargoCode\":\"A.A.01.01.AA010166G\",\"refundNum\":3},{\"batch\":\"20230303D\",\"cargoCode\":\"A.A.01.01.AA010166G\",\"refundNum\":6},{\"batch\":\"20230207J\",\"cargoCode\":\"A.A.01.01.AA010164K\",\"refundNum\":79},{\"batch\":\"20230210J\",\"cargoCode\":\"A.A.01.01.AA010164K\",\"refundNum\":2},{\"batch\":\"20230301D\",\"cargoCode\":\"A.A.01.01.AA010171C\",\"refundNum\":6},{\"batch\":\"20230202D\",\"cargoCode\":\"A.A.01.01.AA010171C\",\"refundNum\":17},{\"batch\":\"20230303G\",\"cargoCode\":\"A.A.01.03.AA010311\",\"refundNum\":50},{\"batch\":\"20230202G\",\"cargoCode\":\"A.A.01.03.AA010311\",\"refundNum\":51},{\"batch\":\"20230201G\",\"cargoCode\":\"A.A.01.03.AA010311\",\"refundNum\":5},{\"batch\":\"20221209G\",\"cargoCode\":\"A.A.01.03.AA010311\",\"refundNum\":3},{\"batch\":\"20230302D\",\"cargoCode\":\"A.A.01.01.AA010175D\",\"refundNum\":6},{\"batch\":\"20230204D\",\"cargoCode\":\"A.A.01.01.AA010175D\",\"refundNum\":3},{\"batch\":\"20230203V\",\"cargoCode\":\"A.A.01.04.AA010450\",\"refundNum\":1},{\"batch\":\"20230202V\",\"cargoCode\":\"A.A.01.04.AA010450\",\"refundNum\":4},{\"batch\":\"20230301G\",\"cargoCode\":\"A.A.01.01.AA010190H\",\"refundNum\":16},{\"batch\":\"20230302A\",\"cargoCode\":\"A.A.01.07.AA010754\",\"refundNum\":40},{\"batch\":\"20230202A\",\"cargoCode\":\"A.A.01.07.AA010754\",\"refundNum\":3},{\"batch\":\"20230246F\",\"cargoCode\":\"A.A.01.01.AA010151AP\",\"refundNum\":5},{\"batch\":\"20230329N\",\"cargoCode\":\"A.A.01.01.AA010151AP\",\"refundNum\":3},{\"batch\":\"20221207F\",\"cargoCode\":\"A.A.01.01.AA010151AP\",\"refundNum\":1},{\"batch\":\"20230240F\",\"cargoCode\":\"A.A.01.01.AA010151AP\",\"refundNum\":2},{\"batch\":\"20230210D\",\"cargoCode\":\"A.A.01.07.AA010733\",\"refundNum\":15},{\"batch\":\"20230302N\",\"cargoCode\":\"A.A.01.07.AA010733\",\"refundNum\":88},{\"batch\":\"20221111D\",\"cargoCode\":\"A.A.01.07.AA010733\",\"refundNum\":1},{\"batch\":\"20230108D\",\"cargoCode\":\"A.A.01.01.AA010163\",\"refundNum\":3},{\"batch\":\"20230204D\",\"cargoCode\":\"A.A.01.01.AA010163\",\"refundNum\":88},{\"batch\":\"20230210D\",\"cargoCode\":\"A.A.01.02.AA010208AL\",\"refundNum\":85},{\"batch\":\"20221204V\",\"cargoCode\":\"A.A.01.02.AA010208AL\",\"refundNum\":1},{\"batch\":\"20230201D\",\"cargoCode\":\"A.A.01.04.AA010445\",\"refundNum\":19},{\"batch\":\"20230202G\",\"cargoCode\":\"A.A.01.02.AA010220AC\",\"refundNum\":79},{\"batch\":\"20230301D\",\"cargoCode\":\"A.A.01.01.AA010169D\",\"refundNum\":8},{\"batch\":\"20230201D\",\"cargoCode\":\"A.A.01.01.AA010169D\",\"refundNum\":2},{\"batch\":\"20230301F\",\"cargoCode\":\"A.A.01.01.AA010103F\",\"refundNum\":6},{\"batch\":\"20230301D\",\"cargoCode\":\"A.A.01.04.AA010413\",\"refundNum\":3},{\"batch\":\"20230203D\",\"cargoCode\":\"A.A.01.04.AA010413\",\"refundNum\":1},{\"batch\":\"20230201D\",\"cargoCode\":\"A.A.01.04.AA010404\",\"refundNum\":2}],\"refundOrderNo\":\"2024100914124001857130713\",\"warehouseCode\":\"00004750254\"}";
        String a1 = "{\"reCheckDetailReqDtoList\":[{\"batch\":\"20221212N\",\"cargoCode\":\"A.A.06.01.AA060102N\",\"refundNum\":34},{\"batch\":\"20221211D\",\"cargoCode\":\"A.A.24.01.AA240104A\",\"refundNum\":1},{\"batch\":\"20230224N\",\"cargoCode\":\"A.A.06.01.AA060102Q\",\"refundNum\":18},{\"batch\":\"20230101D\",\"cargoCode\":\"A.A.24.01.AA240101\",\"refundNum\":6},{\"batch\":\"20221220D\",\"cargoCode\":\"A.A.24.01.AA240102A\",\"refundNum\":3},{\"batch\":\"20221221D\",\"cargoCode\":\"A.A.24.01.AA240102A\",\"refundNum\":4}],\"refundOrderNo\":\"2024100914105703706410641\",\"warehouseCode\":\"00004750252\"}";
        CsReceiveResultOrderAddReqDto b = new CsReceiveResultOrderApiImpl().changeParams((TcbjReCheckReqDto)JSONObject.parseObject((String)a, TcbjReCheckReqDto.class));
        CsReceiveResultOrderAddReqDto b1 = new CsReceiveResultOrderApiImpl().changeParams((TcbjReCheckReqDto)JSONObject.parseObject((String)a1, TcbjReCheckReqDto.class));
        System.out.println(JSONObject.toJSONString((Object)b));
        System.out.println();
        System.out.println(JSONObject.toJSONString((Object)b1));
    }
}

