/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOverchargeAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedRelieveOverchargeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderDetailRespDto;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/csInPlannedOrder"})
public class CsInPlannedOrderRest
implements ICsInPlannedOrderApi,
ICsInPlannedOrderQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsInPlannedOrderRest.class);
    @Resource(name="${yunxi.dg.base.project}_InPlannedOrderApi")
    private ICsInPlannedOrderApi csInPlannedOrderApi;
    @Resource(name="${yunxi.dg.base.project}_InPlannedOrderQueryApi")
    private ICsInPlannedOrderQueryApi csInPlannedOrderQueryApi;

    public RestResponse<Long> add(@Validated @RequestBody CsInPlannedOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)addReqDto));
        return this.csInPlannedOrderApi.add(addReqDto);
    }

    public RestResponse<Void> update(@PathVariable(value="id") Long id, @Validated @RequestBody CsInPlannedOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent((Object)updateReqDto));
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        return this.csInPlannedOrderApi.update(id, updateReqDto);
    }

    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        return this.csInPlannedOrderApi.delete(id);
    }

    public RestResponse<Long> generatePlannedOrder(@Validated @RequestBody CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        return this.csInPlannedOrderApi.generatePlannedOrder(plannedOrderGenerateReqDto);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> auditPlannedOrder(@Validated @RequestBody CsInPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        return this.csInPlannedOrderApi.auditPlannedOrder(plannedOrderAuditReqDto);
    }

    public RestResponse<Void> cancelByOrderNo(@PathVariable(value="orderNo") String orderNo) {
        return this.csInPlannedOrderApi.cancelByOrderNo(orderNo);
    }

    public RestResponse<Long> editPlannedOrder(@Validated @RequestBody CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        return this.csInPlannedOrderApi.editPlannedOrder(plannedOrderGenerateReqDto);
    }

    public RestResponse<Void> submitByOrderNo(@PathVariable(value="orderNo") String orderNo) {
        return this.csInPlannedOrderApi.submitByOrderNo(orderNo);
    }

    public RestResponse<Void> relieveOverchargeByOrderDocumentNo(@Validated @RequestBody CsInPlannedRelieveOverchargeReqDto csInPlannedRelieveOverchargeReqDto) {
        return this.csInPlannedOrderApi.relieveOverchargeByOrderDocumentNo(csInPlannedRelieveOverchargeReqDto);
    }

    public RestResponse<Void> overchargeAdjust(@Validated @RequestBody CsInPlannedOverchargeAdjustReqDto overchargeAdjustReqDto) {
        return this.csInPlannedOrderApi.overchargeAdjust(overchargeAdjustReqDto);
    }

    public RestResponse<CsInPlannedOrderRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        return this.csInPlannedOrderQueryApi.queryByPrimaryKey(id);
    }

    public RestResponse<PageInfo<CsInPlannedOrderRespDto>> queryByPage(@Validated @RequestBody CsInPlannedOrderPageQueryDto inPlannedOrderPageQueryDto) {
        return this.csInPlannedOrderQueryApi.queryByPage(inPlannedOrderPageQueryDto);
    }

    public RestResponse<CsInPlannedOrderDetailQueryInfoRespDto> queryDetailByOrderNo(@PathVariable(value="orderNo") String orderNo) {
        return this.csInPlannedOrderQueryApi.queryDetailByOrderNo(orderNo);
    }

    public RestResponse<List<CsInResultOrderDetailRespDto>> queryOverchargeDetailByDocumentNo(@PathVariable(value="receiveDocumentNo") String receiveDocumentNo) {
        return this.csInPlannedOrderQueryApi.queryOverchargeDetailByDocumentNo(receiveDocumentNo);
    }

    public RestResponse<List<CsInPlannedOrderRespDto>> queryByIds(@RequestBody List<Long> ids) {
        return this.csInPlannedOrderQueryApi.queryByIds(ids);
    }
}

