package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemChannelReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPlatformReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 商品授权渠道关系表服务接口
*
* @author yiyun
* @since 2021-08-18
*/
@Api(tags = {"商品中心：商品授权渠道关系表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemChannelApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/channel",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemChannelApi {

/**
* 新增商品授权渠道关系表
*
* @param addReqDto 商品授权渠道关系表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增商品授权渠道关系表", notes = "新增商品授权渠道关系表")
RestResponse<Long> addItemChannel(@RequestBody ItemChannelReqDto addReqDto);

    /**
    * 修改商品授权渠道关系表
    *
    * @param modifyReqDto 商品授权渠道关系表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品授权渠道关系表", notes = "修改商品授权渠道关系表")
    RestResponse<Void> modifyItemChannel(@RequestBody ItemChannelReqDto modifyReqDto);

    /**
    * 删除商品授权渠道关系表
    *
    * @param ids        商品授权渠道关系表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品授权渠道关系表", notes = "删除商品授权渠道关系表")
    RestResponse<Void> removeItemChannel(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 设置允销平台
     * @param platformReqDto
     * @return
     */
    @PutMapping("/addItemPlatform")
    @ApiOperation(value = "设置允销平台",notes = "设置允销平台")
    RestResponse<Void> addItemPlatform(@RequestBody ItemPlatformReqDto platformReqDto);

    /**
     * 商品授权平台关系导入
     *
     * @param importDto 商品授权平台关系导入
     * @return 处理结果
     */
    @PostMapping("/empowerImport")
    @ApiOperation(value = "商品授权平台关系导入", notes = "商品授权平台关系导入")
    RestResponse<String> empowerImport(@RequestBody ImportDto importDto);

    /**
     * 商品批量设置允销平台
     * @param itemId
     * @param skuId
     * @param shelfIds
     * @return
     */
    @PostMapping("/batchAddItemPlatform")
    @ApiOperation(value = "商品批量设置允销平台", notes = "商品批量设置允销平台")
    RestResponse<Void> batchAddItemPlatform(@RequestParam("itemId") Long itemId, @RequestParam("skuId") Long skuId, @RequestParam("shelfIds") List<Long> shelfIds);

}
