package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEmpowerCallbackReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEmpowerReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ImportEmpowerResultRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 允销授权服务接口
 *
 * @author yiyun
 * @since 2021-08-23
 */
@Api(tags = {"商品中心：允销授权服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemEmpowerApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemEmpower",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemEmpowerApi {

    /**
     * 新增允销授权
     *
     * @param addReqDto 允销授权请求对象
     * @return 处理结果
     */
    @PostMapping("/addItemEmpower")
    @ApiOperation(value = "新增允销授权", notes = "新增允销授权")
    RestResponse<Void> addItemEmpower(@RequestBody List<ItemEmpowerReqDto> addReqDto);

    /**
     * 修改允销授权
     *
     * @param modifyReqDto 允销授权请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改允销授权", notes = "修改允销授权")
    RestResponse<Void> modifyItemEmpower(@RequestBody ItemEmpowerReqDto modifyReqDto);

    /**
     * 修改允销授权（批量）
     *
     * @param modifyReqDto 允销授权请求对象
     * @return 处理结果
     */
    @PostMapping("/modifyItemEmpowerBatch")
    @ApiOperation(value = "修改允销授权（批量）", notes = "修改允销授权（批量）")
    RestResponse<Void> modifyItemEmpowerBatch(@RequestBody ItemEmpowerReqDto modifyReqDto);

    /**
     * 删除允销授权
     *
     * @param ids        允销授权删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除允销授权", notes = "删除允销授权")
    RestResponse<Void> removeItemEmpower(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * OA审批允销授权状态回调
     *
     * @param itemEmpowerCallbackReqDto 允销授权请求对象
     * @return 处理结果
     */
    @PostMapping("/itemEmpowerCallback")
    @ApiOperation(value = "OA审批允销授权状态回调", notes = "OA审批允销授权状态回调")
    RestResponse<Void> itemEmpowerCallback(@RequestBody ItemEmpowerCallbackReqDto itemEmpowerCallbackReqDto);

    /**
     * 允销授权初始化信息
     *
     * @param importDto 导入dto
     * @return 处理结果
     */
    @PostMapping("/initEmpowerInfo")
    @ApiOperation(value = "允销授权初始化信息", notes = "允销授权初始化信息")
    RestResponse<ImportEmpowerResultRespDto> initEmpowerInfo(@RequestBody ImportDto importDto);

}
