package com.dtyunxi.yundt.cube.center.item.api.constants;

import lombok.Getter;

import java.math.BigDecimal;
import java.util.Arrays;

@Getter
public enum WeightUnitEnum {
    MG("MG","毫克",new BigDecimal("1"),new BigDecimal("0.001")),
    G("G","克",new BigDecimal("1"),new BigDecimal("1")),
    KG("KG","千克",new BigDecimal("1"),new BigDecimal("1000")),
    OZ("OZ","盎司",new BigDecimal("1"),new BigDecimal("28.3495231")),
    LB("LB","磅",new BigDecimal("1"),new BigDecimal("453.59237")),
    TO("TO","吨",new BigDecimal("1"),new BigDecimal("1000000")),
    TON("TON","吨（美）",new BigDecimal("1"),new BigDecimal("1000000")),
    ;

    private String unit;
    private String name;
    private BigDecimal baseNum;
    private BigDecimal conversionNum;

    WeightUnitEnum(String unit, String name, BigDecimal baseNum, BigDecimal conversionNum) {
        this.unit = unit;
        this.name = name;
        this.baseNum = baseNum;
        this.conversionNum = conversionNum;
    }

    public static WeightUnitEnum getEnumByUnit(String unit){
        return Arrays.stream(WeightUnitEnum.values()).filter(weightUnitEnum -> weightUnitEnum.getUnit().equals(unit)).findFirst().orElse(null);
    }
}
