package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
* 商品|产品定义Eo对象
*
* @author yiyun
* @since 2021-08-18
*/
@ApiModel(value = "ItemExtRespDto", description = "商品|产品定义Eo对象")
public class ItemExtRespDto extends BaseRespDto {
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  名称
    */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
    *  显示名
    */
    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;
    /**
    *  编码
    */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    /**
    *  
    */
    @ApiModelProperty(name = "brandId", value = "")
    private Long brandId;
    /**
    *  品牌名称
    */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;
    /**
    *  
    */
    @ApiModelProperty(name = "dirId", value = "")
    private Long dirId;
    /**
    *  
    */
    @ApiModelProperty(name = "dirName", value = "")
    private String dirName;

    /**
     *
     */
    @ApiModelProperty(name = "dirPrefixId", value = "")
    private Long dirPrefixId;
    /**
     *
     */
    @ApiModelProperty(name = "dirPrefixName", value = "")
    private String dirPrefixName;

    /**
    *  虚拟商品
    */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;
    /**
    *  介绍
    */
    @ApiModelProperty(name = "brief", value = "介绍")
    private String brief;
    /**
    *  详情
    */
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;
    /**
    *  状态(0已发布 1上架 2下架 3未发布 4禁用状态)
    */
    @ApiModelProperty(name = "status", value = "状态(0已发布 1上架 2下架 3未发布 4禁用状态)")
    private Integer status;
    /**
    *  退货类型：1不可退 2手动可退 3过期自动退
    */
    @ApiModelProperty(name = "returnType", value = "退货类型：1不可退 2手动可退 3过期自动退")
    private Integer returnType;
    /**
    *  允许退货时间点
    */
    @ApiModelProperty(name = "allowReturnTime", value = "允许退货时间点")
    private String allowReturnTime;
    /**
    *  审核状态(0草稿 1待审核 2审核通过 3审核拒绝)
    */
    @ApiModelProperty(name = "auditStatus", value = "审核状态(0草稿 1待审核 2审核通过 3审核拒绝)")
    private Integer auditStatus;
    /**
    *  
    */
    @ApiModelProperty(name = "shelfAmount", value = "")
    private Long shelfAmount;
    /**
    *  
    */
    @ApiModelProperty(name = "shippingTpl", value = "")
    private Long shippingTpl;
    /**
    *  1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品
    */
    @ApiModelProperty(name = "type", value = "1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private Integer type;
    /**
    *  是否售后:0否 1是
    */
    @ApiModelProperty(name = "isAfterSale", value = "是否售后:0否 1是")
    private Integer isAfterSale;
    /**
    *  产品id
    */
    @ApiModelProperty(name = "spuid", value = "产品id")
    private Long spuid;
    /**
    *  商户ID
    */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    /**
    *  店铺ID
    */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
    *  所属人ID
    */
    @ApiModelProperty(name = "ownerId", value = "所属人ID")
    private Long ownerId;
    /**
    *  版本号--审核通过后+1
    */
    @ApiModelProperty(name = "version", value = "版本号--审核通过后+1")
    private Long version;
    /**
    *  销售渠道
    */
    @ApiModelProperty(name = "saleChannel", value = "销售渠道")
    private String saleChannel;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  供应商id
    */
    @ApiModelProperty(name = "supplierId", value = "供应商id")
    private Long supplierId;
    /**
    *  年份 例如：2020
    */
    @ApiModelProperty(name = "year", value = "年份 例如：2020")
    private Integer year;
    /**
    *  0 表示普通商品，1社区团购
    */
    @ApiModelProperty(name = "busType", value = "0 表示普通商品，1社区团购")
    private Integer busType;
    /**
    *  零售限购周期
    */
    @ApiModelProperty(name = "retailLimitPeriod", value = "零售限购周期")
    private String retailLimitPeriod;
    /**
    *  零售限购
    */
    @ApiModelProperty(name = "retailLimit", value = "零售限购")
    private BigDecimal retailLimit;
    /**
    *  最小起售量（单次购买）
    */
    @ApiModelProperty(name = "retailLimitMin", value = "最小起售量（单次购买）")
    private BigDecimal retailLimitMin;
    /**
    *  最大零售量（单次购买）
    */
    @ApiModelProperty(name = "retailLimitMax", value = "最大零售量（单次购买）")
    private BigDecimal retailLimitMax;
    /**
    *  订货限购周期
    */
    @ApiModelProperty(name = "wholesaleLimitPeriod", value = "订货限购周期")
    private String wholesaleLimitPeriod;
    /**
    *  订货限购
    */
    @ApiModelProperty(name = "wholesaleLimit", value = "订货限购")
    private BigDecimal wholesaleLimit;
    /**
    *  最小订货量（单次购买）
    */
    @ApiModelProperty(name = "wholesaleLimitMin", value = "最小订货量（单次购买）")
    private BigDecimal wholesaleLimitMin;
    /**
    *  最大订货量（单次购买）
    */
    @ApiModelProperty(name = "wholesaleLimitMax", value = "最大订货量（单次购买）")
    private BigDecimal wholesaleLimitMax;


    /**
     *  销售组织
     */
    @ApiModelProperty(name = "saleOrganization")
    private String saleOrganization;


    /**
     *  分销渠道
     */
    @ApiModelProperty(name = "distributionChannel")
    private String distributionChannel;

    /**
     *  MWSI税码
     */
    @ApiModelProperty(name = "nwsiCode")
    private String nwsiCode;

    /**
     *  交货工厂
     */
    @ApiModelProperty(name = "deliveryFactory")
    private String deliveryFactory;

    /**
     *  物料运输组
     */
    @ApiModelProperty(name = "material_group")
    private String material_group;

    /**
     *  项目类别组
     */
    @ApiModelProperty(name = "projectGroup")
    private String projectGroup;

    /**
     *  科目设置组
     */
    @ApiModelProperty(name = "accountSettingGroup")
    private String accountSettingGroup;


    /**
     *  产品实际上市日期
     */
    @ApiModelProperty(name = "actualLaunchDate")
    private String actualLaunchDate;


    /**
     *  产品实际下市日期
     */
    @ApiModelProperty(name = "actualDelistingDate")
    private String actualDelistingDate;


    /**
     *  商品的等级分类
     */
    @ApiModelProperty(name = "productGradeClassify")
    private String productGradeClassify;


    /**
     *  产品大类
     */
    @ApiModelProperty(name = "prodLargeClass")
    private String prodLargeClass;

    /**
     *  产品二级分类
     */
    @ApiModelProperty(name = "prodSecClassify")
    private String prodSecClassify;


    /**
     *  产品负责人
     */
    @ApiModelProperty(name = "principalPerson")
    private String principalPerson;

    /**
     *  EN（69码）
     */
    @ApiModelProperty(name = "enCode")
    private String enCode;

    /**
     *  内包装规格（PC长宽高）
     */
    @ApiModelProperty(name = "pcSpecs")
    private BigDecimal pcSpecs;

    /**
     *  外包装规格（CAR长宽高）
     */
    @ApiModelProperty(name = "carSpecs")
    private BigDecimal carSpecs;


    /**
     *  国内B2B卖点
     */
    @ApiModelProperty(name = "domesticB2b")
    private String domesticB2b;


    /**
     *  国外B2B卖点
     */
    @ApiModelProperty(name = "internalB2b")
    private String internalB2b;

    /**
     *  物料类型
     */
    @ApiModelProperty(name = "materialsType")
    private String materialsType;

    /**
     *  食材(保质期)
     */
    @ApiModelProperty(name = "ingredientsShelfLife")
    private String ingredientsShelfLife;

    /**
     * 负责部门
     */
    @ApiModelProperty(name = "department")
    private String department;



    @ApiModelProperty(name = "createTime")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(name = "updateTime")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;



    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }
    public void setDisplayName(String displayName){
    this.displayName = displayName;
    }
    public String getDisplayName(){
    return this.displayName;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setBrandId(Long brandId){
    this.brandId = brandId;
    }
    public Long getBrandId(){
    return this.brandId;
    }
    public void setBrand(String brand){
    this.brand = brand;
    }
    public String getBrand(){
    return this.brand;
    }
    public void setDirId(Long dirId){
    this.dirId = dirId;
    }
    public Long getDirId(){
    return this.dirId;
    }
    public void setDirName(String dirName){
    this.dirName = dirName;
    }
    public String getDirName(){
    return this.dirName;
    }
    public void setVitrual(Boolean vitrual){
    this.vitrual = vitrual;
    }
    public Boolean getVitrual(){
    return this.vitrual;
    }
    public void setBrief(String brief){
    this.brief = brief;
    }
    public String getBrief(){
    return this.brief;
    }
    public void setDetail(String detail){
    this.detail = detail;
    }
    public String getDetail(){
    return this.detail;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public void setReturnType(Integer returnType){
    this.returnType = returnType;
    }
    public Integer getReturnType(){
    return this.returnType;
    }
    public void setAllowReturnTime(String allowReturnTime){
    this.allowReturnTime = allowReturnTime;
    }
    public String getAllowReturnTime(){
    return this.allowReturnTime;
    }
    public void setAuditStatus(Integer auditStatus){
    this.auditStatus = auditStatus;
    }
    public Integer getAuditStatus(){
    return this.auditStatus;
    }
    public void setShelfAmount(Long shelfAmount){
    this.shelfAmount = shelfAmount;
    }
    public Long getShelfAmount(){
    return this.shelfAmount;
    }
    public void setShippingTpl(Long shippingTpl){
    this.shippingTpl = shippingTpl;
    }
    public Long getShippingTpl(){
    return this.shippingTpl;
    }
    public void setType(Integer type){
    this.type = type;
    }
    public Integer getType(){
    return this.type;
    }
    public void setIsAfterSale(Integer isAfterSale){
    this.isAfterSale = isAfterSale;
    }
    public Integer getIsAfterSale(){
    return this.isAfterSale;
    }
    public void setSpuid(Long spuid){
    this.spuid = spuid;
    }
    public Long getSpuid(){
    return this.spuid;
    }
    public void setSellerId(Long sellerId){
    this.sellerId = sellerId;
    }
    public Long getSellerId(){
    return this.sellerId;
    }
    public void setShopId(Long shopId){
    this.shopId = shopId;
    }
    public Long getShopId(){
    return this.shopId;
    }
    public void setOwnerId(Long ownerId){
    this.ownerId = ownerId;
    }
    public Long getOwnerId(){
    return this.ownerId;
    }
    public void setVersion(Long version){
    this.version = version;
    }
    public Long getVersion(){
    return this.version;
    }
    public void setSaleChannel(String saleChannel){
    this.saleChannel = saleChannel;
    }
    public String getSaleChannel(){
    return this.saleChannel;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setSupplierId(Long supplierId){
    this.supplierId = supplierId;
    }
    public Long getSupplierId(){
    return this.supplierId;
    }
    public void setYear(Integer year){
    this.year = year;
    }
    public Integer getYear(){
    return this.year;
    }
    public void setBusType(Integer busType){
    this.busType = busType;
    }
    public Integer getBusType(){
    return this.busType;
    }
    public void setRetailLimitPeriod(String retailLimitPeriod){
    this.retailLimitPeriod = retailLimitPeriod;
    }
    public String getRetailLimitPeriod(){
    return this.retailLimitPeriod;
    }
    public void setRetailLimit(BigDecimal retailLimit){
    this.retailLimit = retailLimit;
    }
    public BigDecimal getRetailLimit(){
    return this.retailLimit;
    }
    public void setRetailLimitMin(BigDecimal retailLimitMin){
    this.retailLimitMin = retailLimitMin;
    }
    public BigDecimal getRetailLimitMin(){
    return this.retailLimitMin;
    }
    public void setRetailLimitMax(BigDecimal retailLimitMax){
    this.retailLimitMax = retailLimitMax;
    }
    public BigDecimal getRetailLimitMax(){
    return this.retailLimitMax;
    }
    public void setWholesaleLimitPeriod(String wholesaleLimitPeriod){
    this.wholesaleLimitPeriod = wholesaleLimitPeriod;
    }
    public String getWholesaleLimitPeriod(){
    return this.wholesaleLimitPeriod;
    }
    public void setWholesaleLimit(BigDecimal wholesaleLimit){
    this.wholesaleLimit = wholesaleLimit;
    }
    public BigDecimal getWholesaleLimit(){
    return this.wholesaleLimit;
    }
    public void setWholesaleLimitMin(BigDecimal wholesaleLimitMin){
    this.wholesaleLimitMin = wholesaleLimitMin;
    }
    public BigDecimal getWholesaleLimitMin(){
    return this.wholesaleLimitMin;
    }
    public void setWholesaleLimitMax(BigDecimal wholesaleLimitMax){
    this.wholesaleLimitMax = wholesaleLimitMax;
    }
    public BigDecimal getWholesaleLimitMax(){
    return this.wholesaleLimitMax;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }

    public String getSaleOrganization() {
        return saleOrganization;
    }

    public void setSaleOrganization(String saleOrganization) {
        this.saleOrganization = saleOrganization;
    }

    public String getDistributionChannel() {
        return distributionChannel;
    }

    public void setDistributionChannel(String distributionChannel) {
        this.distributionChannel = distributionChannel;
    }

    public String getNwsiCode() {
        return nwsiCode;
    }

    public void setNwsiCode(String nwsiCode) {
        this.nwsiCode = nwsiCode;
    }

    public String getDeliveryFactory() {
        return deliveryFactory;
    }

    public void setDeliveryFactory(String deliveryFactory) {
        this.deliveryFactory = deliveryFactory;
    }

    public String getMaterial_group() {
        return material_group;
    }

    public void setMaterial_group(String material_group) {
        this.material_group = material_group;
    }

    public String getProjectGroup() {
        return projectGroup;
    }

    public void setProjectGroup(String projectGroup) {
        this.projectGroup = projectGroup;
    }

    public String getAccountSettingGroup() {
        return accountSettingGroup;
    }

    public void setAccountSettingGroup(String accountSettingGroup) {
        this.accountSettingGroup = accountSettingGroup;
    }

    public String getActualLaunchDate() {
        return actualLaunchDate;
    }

    public void setActualLaunchDate(String actualLaunchDate) {
        this.actualLaunchDate = actualLaunchDate;
    }

    public String getActualDelistingDate() {
        return actualDelistingDate;
    }

    public void setActualDelistingDate(String actualDelistingDate) {
        this.actualDelistingDate = actualDelistingDate;
    }

    public String getProductGradeClassify() {
        return productGradeClassify;
    }

    public void setProductGradeClassify(String productGradeClassify) {
        this.productGradeClassify = productGradeClassify;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getPrincipalPerson() {
        return principalPerson;
    }

    public void setPrincipalPerson(String principalPerson) {
        this.principalPerson = principalPerson;
    }

    public String getEnCode() {
        return enCode;
    }

    public void setEnCode(String enCode) {
        this.enCode = enCode;
    }

    public BigDecimal getPcSpecs() {
        return pcSpecs;
    }

    public void setPcSpecs(BigDecimal pcSpecs) {
        this.pcSpecs = pcSpecs;
    }

    public BigDecimal getCarSpecs() {
        return carSpecs;
    }

    public void setCarSpecs(BigDecimal carSpecs) {
        this.carSpecs = carSpecs;
    }

    public String getDomesticB2b() {
        return domesticB2b;
    }

    public void setDomesticB2b(String domesticB2b) {
        this.domesticB2b = domesticB2b;
    }

    public String getInternalB2b() {
        return internalB2b;
    }

    public void setInternalB2b(String internalB2b) {
        this.internalB2b = internalB2b;
    }

    public String getMaterialsType() {
        return materialsType;
    }

    public void setMaterialsType(String materialsType) {
        this.materialsType = materialsType;
    }

    public String getIngredientsShelfLife() {
        return ingredientsShelfLife;
    }

    public void setIngredientsShelfLife(String ingredientsShelfLife) {
        this.ingredientsShelfLife = ingredientsShelfLife;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }


    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
