/*
 * @(#)IItemStorageExtApi.java 1.0 2022年01月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReturnReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageSubReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BatchItemStorageRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>Title:IItemStorageExtApi</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2022/1/12 0:24
 * @since 0.1.0
 */
@Api(tags = {"商品中心：商品库存接口扩展服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemStorageExtApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/storage/ext",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemStorageExtApi {

    @PostMapping({""})
    @ApiOperation(
            value = "新增/扣减商品库存",
            notes = "新增/扣减商品库存(balance大于0为新增，PS：balance为增量值不为库存总值;balance小于0为扣减)"
    )
    RestResponse<Long> operatingItemStorage(@RequestBody ItemStorageReqDto itemStorageReqDto);

    @PostMapping({"/batch"})
    @ApiOperation(
            value = "新增/扣减商品库存",
            notes = "新增/扣减商品库存(balance大于0为新增，PS：balance为增量值不为库存总值;balance小于0为扣减)"
    )
    RestResponse<BatchItemStorageRespDto> batchOperatingItemStorage(@RequestBody BatchItemStorageReqDto batchItemStorageReqDto);

    /** @deprecated */
    @PutMapping({""})
    @ApiOperation(
            value = "预占商品库存(下订单时使用),已经废弃，只用新增和扣减",
            notes = "预占商品库存(下订单时使用),已经废弃，只用新增和扣减"
    )
    @Deprecated
    RestResponse<Void> subItemStorage(@RequestBody ItemStorageSubReqDto itemStorageSubReqDto);

    @PutMapping({"/return"})
    @ApiOperation(
            value = "虚拟商品库存回退",
            notes = "虚拟商品库存回退"
    )
    RestResponse<Void> returnItemStorage(@RequestBody ItemStorageReturnReqDto itemStorageReturnReqDto);

}
