package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.OnItemTobReqDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author :wuhui
 * @Desc:TODO
 * @Date:2023/7/3 14:43
 */
@Data
public class OnItemTobExtReqDto extends OnItemTobReqDto {

    /**
     * 库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存
     */
    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMin", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    /**
     * 订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)
     */
    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    /**
     * 首页推荐 0 H5商城 1 Web商城(多选用","分割)
     */
    @ApiModelProperty(name = "homePageDisplay", value = "首页推荐 0 H5商城 1 Web商城(多选用\",\"分割)")
    private String homePageDisplay;

    /**
     * 组织Id
     */
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "sellerId", value = "商户ID，选填")
    private Long sellerId;
}
