package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.EmpowerQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemMainReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.EmpowerItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCountRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemEmpowerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemsEmpowerListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 允销授权服务接口
 *
 * @author yiyun
 * @since 2021-08-23
 */
@Api(tags = {"商品中心：允销授权服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemEmpowerQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemEmpower",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemEmpowerQueryApi {

    /**
     * 根据id查询允销授权
     *
     * @param id 允销授权id
     * @return 允销授权数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询允销授权", notes = "根据id查询允销授权")
    RestResponse<ItemEmpowerRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据授权状态查询数据
     * @param empowerStatus
     * @return
     */
    @GetMapping("/queryAllEmpowerByStatus")
    @ApiOperation(value = "根据授权状态查询数据", notes = "根据授权状态查询数据")
    RestResponse<List<ItemEmpowerRespDto>> queryAllEmpowerByStatus(@RequestParam("empowerStatus") List<String> empowerStatus, @RequestParam("itemCode") String itemCode);

    /**
     * 根据商品编码集合查询(授权状态为待授权和已授权)允销授权信息
     *
     * @param itemCodes 允销商品编码
     * @return 允销授权数据
     */
    @PostMapping("/queryByItemCodes")
    @ApiOperation(value = "根据商品编码集合查询(授权状态为待授权和已授权)允销授权信息", notes = "根据商品编码集合查询(授权状态为待授权和已授权)允销授权信息")
    RestResponse<List<ItemEmpowerRespDto>> queryByItemCodes(@RequestParam("codes") List<String> itemCodes);

    /**
     * 根据商品编码集合查询(授权状态为待授权和已授权)允销授权信息
     *
     * @param customerCodes 允销商品编码
     * @return 允销授权数据
     */
    @PostMapping("/queryByCustomerCodes")
    @ApiOperation(value = "根据客户编码编码集合查询(授权状态为待授权和已授权)允销授权信息", notes = "根据客户编码编码集合查询(授权状态为待授权和已授权)允销授权信息")
    RestResponse<List<ItemEmpowerRespDto>> queryByCustomerCodes(@RequestParam("customerCodes") List<String> customerCodes);

    /**
     * 允销授权分页数据
     *
     * @param filter   允销授权查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 允销授权分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "允销授权分页数据", notes = "根据filter查询条件查询允销授权数据，filter=ItemEmpowerReqDto")
    RestResponse<PageInfo<ItemEmpowerRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询允销客户列表
     *
     * @param mainReqDto
     * @return
     */
    @GetMapping("/queryEmpowerPage")
    @ApiOperation(value = "查询允销客户列表", notes = "查询允销客户列表")
    RestResponse<PageInfo<ItemsEmpowerListRespDto>> queryEmpowerPage(@ModelAttribute ItemMainReqDto mainReqDto);

    /**
     * 根据商品ID查询允销客户详情
     *
     * @param itemId
     * @param empowerStatus
     * @return
     */
    @GetMapping(value = "/getItemEmpower")
    @ApiOperation(value = "根据商品ID查询允销客户详情")
    RestResponse<PageInfo<ItemEmpowerRespDto>> getItemEmpower(@RequestParam("itemId") Long itemId,
                                                              @RequestParam("empowerStatus") Integer empowerStatus,
                                                              @RequestParam(name = "customerCode", required = false) String customerCode,
                                                              @RequestParam(name = "customerName", required = false) String customerName,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 客户的授权商品id 集合
     *
     * @param customerId
     * @return
     */
    @PutMapping({"/power/item/{customerId}"})
    @ApiOperation(
            value = "客户的授权商品id 集合",
            notes = "客户的授权商品id 集合"
    )
    RestResponse<List<Long>> queryItemsByCustomer(@PathVariable("customerId") Long customerId);


    /**
     * 根据客户id查询和授权状态查询授权商品分页数据
     *
     * @param pageNum
     * @param pageSize
     * @return 授权商品集合
     */
    @GetMapping({"/item/selectItemPageByCustomerId"})
    @ApiOperation(
            value = "根据客户id查询和授权状态查询授权商品分页数据",
            notes = "根据客户id查询和授权状态查询授权商品分页数据"
    )
    RestResponse<PageInfo<ItemEmpowerRespDto>> selectItemPageByCustomerId(@RequestParam("customerId") Long customerId,
                                                                          @RequestParam("empowerStatus") Integer empowerStatus,
                                                                          @RequestParam(name = "itemCode",required = false) String itemCode,
                                                                          @RequestParam(name = "itemName",required = false) String itemName,
                                                                          @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据客户id集合查询已授权的商品个数
     *
     * @param customerIds
     * @return
     */
    @GetMapping({"/item/queryItemCountByCustomerId"})
    @ApiOperation(
            value = "根据客户id集合查询已授权的商品个数",
            notes = "根据客户id集合查询已授权的商品个数"
    )
    RestResponse<List<ItemCountRespDto>> queryItemCountByCustomerId(@RequestParam("customerIds") List<Long> customerIds);

    /**
     * 分页查询未授权的商品数据
     *
     * @param reqDto
     * @return
     */
    @PostMapping({"/item/empowerItemPage"})
    @ApiOperation(
            value = "分页查询未授权的商品数据",
            notes = "分页查询未授权的商品数据"
    )
    RestResponse<PageInfo<EmpowerItemRespDto>> empowerItemPage(@RequestBody EmpowerQueryReqDto reqDto);
    /**
     * 根据客户id查询客户允销商品集合的详情信息
     *
     * @param customerId
     * @return
     */
    @PostMapping({"/item/selectListByCustomerId"})
    @ApiOperation(
            value = "根据客户id查询客户允销商品集合的详情信息",
            notes = "根据客户id查询客户允销商品集合的详情信息"
    )
    RestResponse<List<ItemEmpowerRespDto>> selectListByCustomerId(@RequestParam("customerId") Long customerId);


    /**
     * 根据客户id查询客户允销商品集合的详情信息(商城使用)
     *
     * @param customerId
     * @return
     */
    @PostMapping({"/item/queryItemIdByCustomerId"})
    @ApiOperation(
            value = "根据客户id查询客户允销商品集合的详情信息(商城使用)",
            notes = "根据客户id查询客户允销商品集合的详情信息(商城使用)"
    )
    RestResponse<List<ItemEmpowerRespDto>> queryItemIdByCustomerId(@RequestParam("customerId") Long customerId);


    /**
     * 根据商品id查询客户允销商品集合的详情信息
     *
     * @param itemId
     * @return
     */
    @PostMapping({"/item/getEmpowerItemListByItemId"})
    @ApiOperation(
            value = "根据商品id查询客户允销商品集合的详情信息",
            notes = "根据商品id查询客户允销商品集合的详情信息"
    )
    RestResponse<List<ItemEmpowerRespDto>> getEmpowerItemListByItemId(@RequestParam("itemId") Long itemId);

    /**
     * 查询存在已允销的数据
     * @param queryReqDto
     * @return
     */
    @PostMapping({"/item/getExistEmpowerItem"})
    @ApiOperation(
            value = "查询存在已允销的数据",
            notes = "查询存在已允销的数据"
    )
    RestResponse<List<ItemEmpowerRespDto>> getExistEmpowerItem(@RequestBody EmpowerQueryReqDto queryReqDto);


}
