package com.dtyunxi.yundt.cube.center.item.api.base.constants;

public enum ItemStatus {
    /**
     *  商品枚举
     */
    ITEM_DRAFT(0, "草稿"),
    ITEM_AUDITING(3, "待审核"),
    ITEM_AUDIT_SUCCESS(4, "待上架/审核通过"),
    ITEM_ONSHELF(1, "已上架"),
    ITEM_OFFSHELF(2, "已下架"),
    ITEM_AUDIT_FAIL(5, "审核不通过"),
    ITEM_SALE_OUT(6, "已售空"),
    /**
     * 产品枚举
     */
    PRODUCT_WAIT_PUBLISHED(0, "未发布"),
    PRODUCT_PUBLISHED(4, "已发布"),
    PRODUCT_DISABLE(7, "禁用状态");

    private Integer status;
    private String desc;

    ItemStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDesc(Integer index) {
        for (ItemStatus statusEnum : ItemStatus.values()) {
            if (statusEnum.getStatus().equals(index)) {
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
