/*
 * @(#) PriceTypeReqDto.java 1.0 2018-09-03
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 价格类型 dto
 *
 * @author
 * @since 2.0.0
 */
@ApiModel(value = "PriceTypeReqDto", description = "价格类型")
public class PriceTypeReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码，必填")
    private String code;
    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "名称，必填")
    private String name;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间，选填，查询时使用")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间，选填，查询时使用")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间，选填，查询时使用")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间，选填，查询时使用")
    private String updateEndTime;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

}