package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * <p>Title:ItemExtDetailRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/8/25 15:39
 * @since 0.1.0
 */
@ApiModel( value = "ItemExtDetailRespDto", description = "商品详情Dto")
@Data
public class ItemExtDetailRespDto extends BaseRespDto {

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "id", value = "商品ID")
    private Long id;

    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "brief", value = "商品介绍")
    private String brief;

    @ApiModelProperty(name = "detail", value = "商品详情")
    private String detail;

    @ApiModelProperty(name = "status", value = "上架状态，1：已上架，2：已下架")
    private Integer status;


    @ApiModelProperty(name = "price", value = "价格")
    private String price;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "inventoryQuantity", value = "库存")
    private String inventoryQuantity;

    @ApiModelProperty(name = "itemMediasList", value = "多媒体列表")
    private List<ItemMediasRespDto> itemMediasList;

    @ApiModelProperty(name = "skuRespDtoList", value = "商品规格信息")
    private List<ItemSkuRespDto> skuRespDtoList;

    @ApiModelProperty(name = "isCollect", value = "是否收藏：0：否，1：是")
    private String isCollect;
    @ApiModelProperty(name = "specContent", value = "规格型号")
    private String specContent;
    @ApiModelProperty(name = "saleCount", value = "销量")
    private Long saleCount;

    @ApiModelProperty(name = "collectItemId", value = "收藏商品对应的id,商品详情删除收藏使用")
    private Long collectItemId;
    @ApiModelProperty(name = "isAllowSale", value = "是否允销 0 否，1：是")
    private Integer isAllowSale;

    @ApiModelProperty(name = "type", value = "type")
    private Integer type;
    @ApiModelProperty(name = "subItemCodeMap", value = "subItemCodeMap")
    private Map<String, Integer> subItemCodeMap;

}
