package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemChangeApplyRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags = {"商品中心：变更服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-query-IItemChangeApplyQueryApi",
        path = "/v1/item/apply",
        url = "${yundt.cube.center.item.api:}")
public interface IItemChangeApplyQueryApi {

    /**
     * 跟据变更申请Id查询商品变更申请详情
     *
     * @param id 变更Id
     * @param filter 过滤对象
     * @return 统一返回响应对象，业务数据data为商品DtoA
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "跟据变更申请Id查询商品变更申请详情", notes = "跟据变更申请id查询商品变更申请详情 ")
    RestResponse<ItemChangeApplyRespDto> queryItemChangeApplyById(@PathVariable("id") Long id,
                                                              @RequestParam(name = "filter", required = false) String filter);

    /**
     * 分页查询商品变更申请列表 filter -> ItemChangeApplyReqDto
     *
     * @param filter   ItemChangeApplyReqDto
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return 统一返回响应对象，业务数据data为商品Dto分页列表
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询商品版本列表", notes = "分页查询商品版本列表，filter=ItemChangeApplyReqDto")
    RestResponse<PageInfo<ItemChangeApplyRespDto>> queryItemChangeApplyByPage(@RequestParam("filter") String filter,
                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);




}
