package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemControlPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemControlPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemPriceControlRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 价格管理表服务接口
*
* @author author
* @since 2022-08-10
*/
@Api(tags = {"价格管理表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemPriceControl",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPriceControlQueryApi {

    /**
    * 根据id查询价格管理表
    *
    * @param id 价格管理表id
    * @return   价格管理表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询价格管理表", notes = "根据id查询价格管理表")
    RestResponse<ItemPriceControlRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 价格管理表分页数据
    *
    * @param filter   价格管理表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 价格管理表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "价格管理表分页数据", notes = "根据filter查询条件查询价格管理表数据，filter=ItemPriceControlReqDto")
    RestResponse<PageInfo<ItemPriceControlRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询
     * @param reqDto
     * @return
     */
    @PostMapping("/page")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<ItemPriceControlRespDto>> queryByPage(@Validated @RequestBody ItemControlPriceReqDto reqDto);

    /**
     * 查询商品价格
     * @param reqDto
     * @return
     */
    @PostMapping("/queryItemPriceByCode")
    @ApiOperation(value = "根据商品code查询商品价格", notes = "根据商品code查询商品价格")
    RestResponse<List<ItemPriceControlRespDto>> queryItemPriceByCode(@Validated @RequestBody ItemControlPriceQueryReqDto reqDto);
}
