/**
 * @(#)DistributionSetReqDto.java 1.0 2020/11/24
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 商品分销设置响应DTO
 *
 * @author wu.sheng
 * @date 2020/11/24 15:08
 */
@ApiModel(value = "DistributionSetRespDto", description = "商品分销设置响应DTO")
public class DistributionSetRespDto extends BaseReqDto {

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;
    /**
     * 规格id
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    /**
     * 设置类型：0默认值，1定义比例，2自定义固定值
     */
    @ApiModelProperty(name = "setType", value = "设置类型：0默认值，1定义比例，2自定义固定值")
    private Integer setType;

    /**
     * 一级佣金
     */
    @ApiModelProperty(name = "firstLevelAmount", value = "一级佣金")
    private BigDecimal firstLevelAmount;

    /**
     * 二级佣金
     */
    @ApiModelProperty(name = "secondLevelAmount", value = "二级佣金")
    private BigDecimal secondLevelAmount;

    /**
     * 一级积分
     */
    @ApiModelProperty(name = "firstLevelPoint", value = "一级积分")
    private BigDecimal firstLevelPoint;


    /**
     * 二级积分
     */
    @ApiModelProperty(name = "secondLevelPoint", value = "二级积分")
    private BigDecimal secondLevelPoint;


    /**
     * 值类型：1比例，2固定比例
     */
    @ApiModelProperty(name = "valueType", value = "值类型：1比例，2固定值")
    private Integer valueType;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DistributionSetRespDto)) return false;
        DistributionSetRespDto that = (DistributionSetRespDto) o;
        return getShopId().equals(that.getShopId()) &&
                getItemId().equals(that.getItemId()) &&
                getSkuId().equals(that.getSkuId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getShopId(), getItemId(), getSkuId());
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getSetType() {
        return setType;
    }

    public void setSetType(Integer setType) {
        this.setType = setType;
    }

    public BigDecimal getFirstLevelAmount() {
        return firstLevelAmount;
    }

    public void setFirstLevelAmount(BigDecimal firstLevelAmount) {
        this.firstLevelAmount = firstLevelAmount;
    }

    public BigDecimal getSecondLevelAmount() {
        return secondLevelAmount;
    }

    public void setSecondLevelAmount(BigDecimal secondLevelAmount) {
        this.secondLevelAmount = secondLevelAmount;
    }

    public BigDecimal getFirstLevelPoint() {
        return firstLevelPoint;
    }

    public void setFirstLevelPoint(BigDecimal firstLevelPoint) {
        this.firstLevelPoint = firstLevelPoint;
    }

    public BigDecimal getSecondLevelPoint() {
        return secondLevelPoint;
    }

    public void setSecondLevelPoint(BigDecimal secondLevelPoint) {
        this.secondLevelPoint = secondLevelPoint;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
}
