package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
* 出厂价同步记录Eo对象
*
* @author author
* @since 2022-08-25
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemDepartmentPriceReqDto", description = "出厂价同步记录Eo对象")
public class ItemDepartmentPriceReqDto extends RequestDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  商品id
    */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;
    /**
    *  商品编码
    */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
    *  部门编码
    */
    @ApiModelProperty(name = "departmentCode", value = "部门编码")
    private String departmentCode;
    /**
    *  价格
    */
    @ApiModelProperty(name = "itemPrice", value = "价格")
    private BigDecimal itemPrice;
    /**
    *  计量单位
    */
    @ApiModelProperty(name = "itemUnit", value = "计量单位")
    private String itemUnit;

    /**
     *  创建开始时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     *  更新开始时间
     */
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    /**
     *  操作人
     */
    @ApiModelProperty(name = "updatePerson", value = "操作人")
    private String updatePerson;

    /**
     *  创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

}
