//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.dtyunxi.yundt.cube.center.item.api.b2b;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthStateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemOnShelfListTobReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthAddBatchRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(
    tags = {"商品中心：商品授权"}
)
@FeignClient(
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item-auth",
    contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-query-IItemAuthQueryApi",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemAuthApi {
    @PostMapping({"state"})
    @ApiOperation("商品禁用/启用")
    RestResponse<Void> state(@RequestBody @Valid ItemAuthStateReqDto itemAuthReqDto);

    @PostMapping({""})
    @ApiOperation(
        value = "新增商品授权表",
        notes = "新增商品授权表"
    )
    RestResponse<Long> addItemAuth(@RequestBody ItemAuthReqDto addReqDto);

    @PutMapping({""})
    @ApiOperation(
        value = "修改商品授权表",
        notes = "修改商品授权表"
    )
    RestResponse<Void> modifyItemAuth(@RequestBody ItemAuthReqDto modifyReqDto);

    @DeleteMapping({"/{ids}"})
    @ApiOperation(
        value = "删除商品授权表",
        notes = "删除商品授权表"
    )
    RestResponse<Void> removeItemAuth(@PathVariable("ids") String ids, @RequestParam(value = "instanceId",required = false) Long instanceId);

    @PostMapping({"batch"})
    @ApiOperation(
        value = "新增商品授权",
        notes = "新增商品授权，支持批量"
    )
    RestResponse<List<Long>> batchItemAuth(@RequestBody ItemAuthAddBatchRespDto itemAuthAddBatchRespDto);

    @PutMapping({"/batch/on-shelf"})
    @ApiOperation(
        value = "批量上架商品(B端专用)",
        notes = "批量上架商品(B端专用)"
    )
    RestResponse<Void> batchOnShelfItem(@RequestBody ItemOnShelfListTobReqDto itemOnShelfListReqDto);

    @PostMapping({"/batch/add"})
    @ApiOperation(
        value = "批量新增商品授权",
        notes = "批量新增商品授权"
    )
    RestResponse<List<Long>> batchAddItemAuth(@RequestBody List<ItemAuthReqDto> itemAuthReqDtoList);

    @PostMapping({"/batch/new/add"})
    @ApiOperation(
        value = "批量新增商品授权(删除再新增)",
        notes = "批量新增商品授权(删除再新增)"
    )
    RestResponse<Void> batchNewAddItemAuth(@RequestBody List<ItemAuthReqDto> itemAuthReqDtoList);
}
