package com.dtyunxi.yundt.cube.center.item.api.b2b.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemNumRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 商品授权-客户指定授权商品服务接口
 *
 * @author cijian
 * @since 2022-11-14
 */
@Api(tags = {"商品授权-客户指定授权商品服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-item-api-api-query-ICustomerAuthItemQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/customerAuthItem",
        url = "${yundt.cube.center.item.api:}"
)
public interface ICustomerAuthItemQueryApi {

    /**
     * 查看客户已授权商品
     *
     * @param customerAuthItemPageReqDto 商品授权-客户指定授权商品查询条件
     * @return 商品授权-客户指定授权商品分页数据
     */
    @PostMapping("/auth/page")
    @ApiOperation(value = "查看客户已授权商品", notes = "查看客户已授权商品")
    RestResponse<PageInfo<CustomerAuthItemRespDto>> queryAuthItemPage(@RequestBody @Valid CustomerAuthItemPageReqDto customerAuthItemPageReqDto);

    /**
     * 统计客户已授权商品/未授权商品数量
     *
     * @param customerAuthItemPageReqDto 商品授权-客户指定授权商品查询条件
     * @return 客户已授权商品/未授权商品数量
     */
    @PostMapping("/auth/num")
    @ApiOperation(value = "统计客户已授权商品/未授权商品数量", notes = "统计客户已授权商品/未授权商品数量")
    RestResponse<CustomerAuthItemNumRespDto> queryAuthItemNum(@RequestBody @Valid CustomerAuthItemPageReqDto customerAuthItemPageReqDto);

}
