//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.CollectionItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api(
    tags = {"商品中心：用户收藏服务"}
)
@FeignClient(
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    contextId = "com-dtyunxi-yundt-cube-center-item-api-collection-ICollectionApi",
    path = "/v1/collection",
    url = "${yundt.cube.center.item.api:}"
)
public interface ICollectionApi {
    @ApiOperation("商品加入收藏")
    @ApiImplicitParam(
        name = "collectionItemReqDto",
        paramType = "body",
        dataType = "CollectionItemReqDto",
        required = true,
        value = "商品信息"
    )
    @PostMapping({"/item"})
    RestResponse<Void> addItem(@Valid @RequestBody CollectionItemQueryDto collectionItemQueryDto);

    @ApiOperation(
        value = "批量删除收用户藏商品",
        notes = "批量删除用户收藏商品，ids多个已逗号隔开"
    )
    @ApiImplicitParam(
        name = "ids",
        paramType = "query",
        dataType = "String",
        required = true,
        value = "用户收藏商品项id"
    )
    @DeleteMapping({"/item"})
    RestResponse<Void> removeItem(@RequestParam("ids") String ids);

    @ApiOperation(
        value = "删除用户收藏商品",
        notes = "删除用户收藏商品"
    )
    @ApiImplicitParams({@ApiImplicitParam(
    name = "itemId",
    paramType = "query",
    dataType = "String",
    required = true,
    value = "商品id"
), @ApiImplicitParam(
    name = "shopId",
    paramType = "query",
    dataType = "String",
    required = true,
    value = "店铺id"
)})
    @DeleteMapping({"/singleItem"})
    RestResponse<Void> removeSingleItem(@RequestParam("itemId") String itemId, @RequestParam("shopId") String shopId);

    @ApiOperation(
        value = "商品是否已收藏",
        notes = "商品是否已收藏"
    )
    @ApiImplicitParams({@ApiImplicitParam(
    name = "itemId",
    value = "商品id",
    paramType = "query",
    dataType = "Long",
    required = true
), @ApiImplicitParam(
    name = "shopId",
    value = "店铺id",
    paramType = "query",
    dataType = "Long",
    required = true
)})
    @GetMapping({"/collected"})
    RestResponse<Boolean> queryCollected(@RequestParam("itemId") Long itemId, @RequestParam("shopId") Long shopId);

    @ApiOperation("获取用户收藏的商品")
    @ApiImplicitParams({@ApiImplicitParam(
    name = "pageNum",
    paramType = "query",
    dataType = "Int",
    defaultValue = "1",
    required = true
), @ApiImplicitParam(
    name = "pageSize",
    paramType = "query",
    dataType = "Int",
    defaultValue = "10",
    required = true
)})
    @GetMapping({"/item"})
    RestResponse<PageInfo<ItemRespDto>> queryCollectionItem(@RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    @ApiOperation("获取用户收藏的下架商品")
    @GetMapping({"/offShelfItem"})
    RestResponse<PageInfo<ItemRespDto>> queryCollectionOffShelfItem(@RequestParam(name = "pageNum",required = false,defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize);
}
