/**
 * @(#) StorageChangeLogStatusEnum.java 1.0 2018-12-03
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 库存表更记录状态枚举
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum StorageChangeLogStatusEnum {
    PREEMPTION(1, "预占"),
    CONFIRM(2, "已确认"),
    CANCEL(3, "已取消"),
    REFUND(4, "确认后取消"),
    CHANGE_BALANCE(5,"变更库存");
    ;

    private Integer status;
    private String desc;

    StorageChangeLogStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDescByStatus(Integer status){
        if (status == null){
            return null;
        }
        for (StorageChangeLogStatusEnum statusEnum : StorageChangeLogStatusEnum.values()){
            if (status.equals(statusEnum.getStatus())){
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
