package com.dtyunxi.yundt.cube.center.item.api.base.constants;

public enum SubTypeEnum {
    PRODUCT(1, "产品"),
    GIFT(2, "赠品"),
    MATERIEL(3, "物料");

    private Integer type;

    private String desc;

    SubTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getSubTypeDesc(Integer type) {
        for (SubTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
