/*
 * @(#)ItemExtendSkuReqDto.java 1.0 2021年09月08日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DistributionSetReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PointsDeductionReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * <p>Title:ItemExtendSkuReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/8 0:01
 * @since 0.1.0
 */
@ApiModel(value = "ItemExtendSkuReqDto", description = "商品上架信息SkuDTO")
public class ItemExtendSkuReqDto extends BaseReqDto {

    @ApiModelProperty(
            name = "cashAmount",
            value = "兑换金额"
    )
    private BigDecimal cashAmount;

    @ApiModelProperty(
            name = "cashIntegral",
            value = "积分"
    )
    private Long cashIntegral;

    @ApiModelProperty(
            name = "cashLimit",
            value = "兑换数量限制"
    )
    private Integer cashLimit;

    @ApiModelProperty(
            name = "distributionSet",
            value = "商品分销设置"
    )
    private DistributionSetReqDto distributionSet;

    @ApiModelProperty(
            name = "itemId",
            value = "商品id，必填"
    )
    private Long itemId;

    @ApiModelProperty(
            name = "pointsDeductionDto",
            value = "积分抵扣规则DTO"
    )
    private PointsDeductionReqDto pointsDeductionDto;

    @ApiModelProperty(
            name = "price",
            value = "价格，选填"
    )
    private BigDecimal price;

    @ApiModelProperty(
            name = "skuId",
            value = "skuId，选填，为空时会上架商品的所有规格，填写为只上架该商品的该规格"
    )
    private Long skuId;

    @ApiModelProperty(
            name = "storage",
            value = "库存"
    )
    private Long storage;


    public BigDecimal getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getCashIntegral() {
        return cashIntegral;
    }

    public void setCashIntegral(Long cashIntegral) {
        this.cashIntegral = cashIntegral;
    }

    public Integer getCashLimit() {
        return cashLimit;
    }

    public void setCashLimit(Integer cashLimit) {
        this.cashLimit = cashLimit;
    }

    public DistributionSetReqDto getDistributionSet() {
        return distributionSet;
    }

    public void setDistributionSet(DistributionSetReqDto distributionSet) {
        this.distributionSet = distributionSet;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public PointsDeductionReqDto getPointsDeductionDto() {
        return pointsDeductionDto;
    }

    public void setPointsDeductionDto(PointsDeductionReqDto pointsDeductionDto) {
        this.pointsDeductionDto = pointsDeductionDto;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getStorage() {
        return storage;
    }

    public void setStorage(Long storage) {
        this.storage = storage;
    }
}
