package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import javax.validation.Valid;
import java.util.List;

/**
* 货品服务接口
*
* @author yuangui
* @since 2022-05-23
*/
@Api(tags = {"货品服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IPcpItemQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/pcpItem",
    url = "${yundt.cube.center.item.api:}"
)
public interface IPcpItemQueryApi {

    /**
    * 根据id查询货品
    *
    * @param id 货品id
    * @return   货品数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询货品", notes = "根据id查询货品")
    RestResponse<PcpItemRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 货品分页数据
    *
    * @param filter   货品查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 货品分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "货品分页数据", notes = "根据filter查询条件查询货品数据，filter=PcpItemReqDto")
    RestResponse<PageInfo<PcpItemRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                       @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                       @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息 ")
    RestResponse<PcpItemRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<PcpItemRespDto>> queryByPage(@Validated @RequestBody PcpItemQueryDto queryDto);
    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryPageByCondition", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<PcpItemRespDto>> queryPageByCondition(@Validated @RequestBody PcpItemQueryDto queryDto);

    /**
     * 参数查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<PcpItemRespDto>> queryByParam(@Validated @RequestBody PcpItemQueryDto queryDto);

    /**
     * 批量查询商品主数据根据商品code集合
     * @param itemCodes
     * @return
     */
    @PostMapping(value = "/queryItemByItemCodes", produces = "application/json")
    @ApiOperation(value = "批量查询商品主数据根据商品code集合", notes = "批量查询商品主数据根据商品code集合")
    RestResponse<List<PcpItemRespDto>> queryItemByItemCodes(@Validated @RequestBody List<String> itemCodes);
    /**
     * 批量查询商品主数据根据商品longCode集合
     * @param itemLongCodes
     * @return
     */
    @PostMapping(value = "/queryItemByItemLongCodes", produces = "application/json")
    @ApiOperation(value = "批量查询商品主数据根据商品code集合", notes = "批量查询商品主数据根据商品code集合")
    RestResponse<List<PcpItemRespDto>> queryItemByItemLongCodes(@Validated @RequestBody List<String> itemLongCodes);

    @PostMapping(value = "/revampItemStatus", produces = "application/json")
    @ApiOperation(value = "批量修改商品状态", notes = "批量修改商品状态")
    RestResponse<Void> revampItemStatus(@ApiParam(value = "") @Valid @RequestBody(required = false) ItemStatusReqDto itemStatusReqDto);

    @PostMapping(value = "/queryPageParams", produces = "application/json")
    @ApiOperation(value = "商品主数据分页列表查询", notes = "商品主数据分页列表查询")
    RestResponse<PageInfo<PcpItemRespDto>> queryPageParams(@RequestBody PcpItemQueryDto queryDto);
}
