/**
 * @(#) DirectorySortUpdateDto.java 1.0 2019-01-07
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 目录排序更新Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "DirectorySortUpdateDto", description = "目录排序更新Dto")
public class DirectorySortUpdateDto extends BaseReqDto {

    /**
     * 排序类型(BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶)
     */
    @ApiModelProperty(name = "sortType", value = "排序类型(BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶)，必填")
    private String sortType;
    /**
     * 原目录ID
     */
    @ApiModelProperty(name = "sourceDirId", value = "原目录ID,要操作目录ID，必填")
    private Long sourceDirId;
    /**
     * 位移目录ID
     */
    @ApiModelProperty(name = "targetDirId", value = "位移目录ID,要移动到的目标目录ID，必填")
    private Long targetDirId;

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Long getSourceDirId() {
        return sourceDirId;
    }

    public void setSourceDirId(Long sourceDirId) {
        this.sourceDirId = sourceDirId;
    }

    public Long getTargetDirId() {
        return targetDirId;
    }

    public void setTargetDirId(Long targetDirId) {
        this.targetDirId = targetDirId;
    }
}
