/**
 * @(#)PropNameRespDto 1.0 2018-12-3
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 属性名响应dto
 *
 * @author 双清
 */
@ApiModel(value = "PropNameRespDto", description = "属性名响应dto")
public class PropNameRespDto extends BaseRespDto {
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    @ApiModelProperty(name = "inputType", value = "编辑方式")
    private Integer inputType;

    @ApiModelProperty(name = "required", value = "是否必选: 1 是 0 否")
    private Integer required;

    @ApiModelProperty(name = "charSizeLimit", value = "字符数限制")
    private Integer charSizeLimit;

    @ApiModelProperty(name = "prompt", value = "提示语")
    private String prompt;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "propValueList", value = "属性值内容")
    private List<String> propValueList;

    @ApiModelProperty(name = "propGroupDtoList", value = "关联的属性组列表")
    private List<PropGroupDto> propGroupDtoList;

    @ApiModelProperty(name = "dirIds", value = "目录ID列表")
    private List<DirPropDto> dirPropDtoList;

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public Integer getCharSizeLimit() {
        return charSizeLimit;
    }

    public void setCharSizeLimit(Integer charSizeLimit) {
        this.charSizeLimit = charSizeLimit;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getInputType() {
        return inputType;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<String> getPropValueList() {
        return propValueList;
    }

    public void setPropValueList(List<String> propValueList) {
        this.propValueList = propValueList;
    }

    public List<PropGroupDto> getPropGroupDtoList() {
        return propGroupDtoList;
    }

    public void setPropGroupDtoList(List<PropGroupDto> propGroupDtoList) {
        this.propGroupDtoList = propGroupDtoList;
    }

    public List<DirPropDto> getDirPropDtoList() {
        return dirPropDtoList;
    }

    public void setDirPropDtoList(List<DirPropDto> dirPropDtoList) {
        this.dirPropDtoList = dirPropDtoList;
    }
}