package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "ItemShelfSkuRespDto", description = "上架商品的sku信息")
public class ItemShelfSkuRespDto {
    @ApiModelProperty(name = "shopId", value = "店铺Id")
    private Long shopId;

    @ApiModelProperty(name = "itemId", value = "商品Id")
    private Long itemId;

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "规格名")
    private String name;

    @ApiModelProperty(name = "cspuid", value = "产品规格")
    private Long cspuid;

    @ApiModelProperty(name = "attr", value = "属性")
    private String attr;

    @ApiModelProperty(name = "price", value = "零售价")
    private BigDecimal price;

    @ApiModelProperty(name = "balance", value = "库存")
    private Long balance;
    /**
     * 体积
     */
    @ApiModelProperty(name="volume", value = "体积")
    private BigDecimal volume;
    /**
     * 货品编码
     */
    @ApiModelProperty(name="cargoCode", value = "货品编码")
    private String cargoCode;
    /**
     * 体积单位
     */
    @ApiModelProperty(name="volumeUnit", value = "体积单位")
    private BigDecimal volumeUnit;

    @ApiModelProperty(name = "itemPriceList", value = "价格列表")
    private List<ItemPriceRespDto> itemPriceList = Lists.newArrayList();

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public BigDecimal getVolumeUnit() {
        return volumeUnit;
    }

    public void setVolumeUnit(BigDecimal volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCspuid() {
        return cspuid;
    }

    public void setCspuid(Long cspuid) {
        this.cspuid = cspuid;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public List<ItemPriceRespDto> getItemPriceList() {
        return itemPriceList;
    }

    public void setItemPriceList(List<ItemPriceRespDto> itemPriceList) {
        this.itemPriceList = itemPriceList;
    }
}
