package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
* 价格管理记录表Eo对象
*
* @author author
* @since 2022-08-10
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemPriceLogReqDto", description = "价格管理记录表Eo对象")
public class ItemPriceLogReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    @ApiModelProperty(name = "type", value = "类型")
    private Integer type;

    @ApiModelProperty(name = "code", value = "客户/渠道编码")
    private String code;

    @ApiModelProperty(name = "name", value = "客户/渠道名称")
    private String name;

    /**
    *  商品id
    */
    @ApiModelProperty(name = "productCode", value = "商品编码")
    private String productCode;
    /**
     *  商品单位
     */
    @ApiModelProperty(name = "productUnit", value = "商品单位")
    private String productUnit;
    /**
    *  修改前价格
    */
    @ApiModelProperty(name = "afterPrice", value = "修改前价格")
    private BigDecimal afterPrice;
    /**
    *  当前价格
    */
    @ApiModelProperty(name = "currentPrice", value = "当前价格")
    private BigDecimal currentPrice;

    @ApiModelProperty(name = "remark", value = "主键ID")
    private String remark;

    @ApiModelProperty(name = "together", value = "是否同步")
    private Boolean together;
}
