package com.dtyunxi.yundt.cube.center.item.api.dto.response.dg;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品价格响应Dto
 *
 * @author 简树 零星
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemPriceDgRespDto", description = "商品价格响应Dto")
public class ItemPriceDgRespDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;
    @ApiModelProperty(name = "createTime", value = "创建时间,yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;
    @ApiModelProperty(name = "updateTime", value = "修改时间,yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;


    /**
     * 价格名称
     */
    @ApiModelProperty(name = "name", value = "价格名称")
    private String name;
    /**
     * 币种
     */
    @ApiModelProperty(name = "currency", value = "币种")
    private String currency;
    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;
    /**
     * 消耗积分
     */
    @ApiModelProperty(name = "points", value = "消耗积分")
    private Long points;
    /**
     * 价格体系
     */
    @ApiModelProperty(name = "priceType", value = "价格体系")
    private String priceType;
    /**
     * 价格体系id
     */
    @ApiModelProperty(name = "priceTypeId", value = "价格体系id")
    private Long priceTypeId;
    /**
     * 是否激活 0不激活 1 激活
     */
    @ApiModelProperty(name = "isActived", value = "是否激活")
    private Integer isActived;
    /**
     * 商品 skuId
     */
    @ApiModelProperty(name = "skuId", value = "商品 skuId")
    private Long skuId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;


}
