/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.api.constants;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public enum LengthUnitEnum {
    NAM("NAM", "\u7eb3\u7c73", new BigDecimal("1"), new BigDecimal("0.0000000001")),
    uM("uM", "\u5fae\u7c73", new BigDecimal("1"), new BigDecimal("0.0000001")),
    MM("MM", "\u6beb\u7c73", new BigDecimal("1"), new BigDecimal("0.001")),
    CM("CM", "\u5398\u7c73", new BigDecimal("1"), new BigDecimal("0.01")),
    DM("DM", "\u5206\u7c73", new BigDecimal("1"), new BigDecimal("0.1")),
    M("M", "\u7c73", new BigDecimal("1"), new BigDecimal("1")),
    FT("FT", "\u82f1\u5c3a", new BigDecimal("1"), new BigDecimal("0.3048")),
    KM("KM", "\u516c\u91cc", new BigDecimal("1"), new BigDecimal("1000")),
    MI("MI", "\u82f1\u91cc", new BigDecimal("1"), new BigDecimal("1609.344")),
    Ml("Ml.", "\u5bc6\u8033", new BigDecimal("1"), new BigDecimal("0.0000254")),
    YD("YD", "\u7801", new BigDecimal("1"), new BigDecimal("0.9144")),
    MM01("MM", "\u6beb\u7c73", new BigDecimal("1"), new BigDecimal("0.1")),
    CM01("CM", "\u5398\u7c73", new BigDecimal("1"), new BigDecimal("1")),
    DM01("DM", "\u5206\u7c73", new BigDecimal("1"), new BigDecimal("10")),
    M01("M", "\u7c73", new BigDecimal("1"), new BigDecimal("100"));

    private String unit;
    private String name;
    private BigDecimal baseNum;
    private BigDecimal conversionNum;
    public static final Map<String, LengthUnitEnum> BANK_TYP_ENUM_MAP;
    public static final Map<String, LengthUnitEnum> M_TYP_ENUM_MAP;

    private LengthUnitEnum(String unit, String name, BigDecimal baseNum, BigDecimal conversionNum) {
        this.unit = unit;
        this.name = name;
        this.baseNum = baseNum;
        this.conversionNum = conversionNum;
    }

    public static LengthUnitEnum getUnit(String unit) {
        LengthUnitEnum businessEnum = BANK_TYP_ENUM_MAP.get(unit);
        return businessEnum;
    }

    public static LengthUnitEnum getEnumByUnit(String unit) {
        LengthUnitEnum businessEnum = M_TYP_ENUM_MAP.get(unit);
        return businessEnum;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getBaseNum() {
        return this.baseNum;
    }

    public BigDecimal getConversionNum() {
        return this.conversionNum;
    }

    static {
        BANK_TYP_ENUM_MAP = new HashMap<String, LengthUnitEnum>();
        M_TYP_ENUM_MAP = new HashMap<String, LengthUnitEnum>();
        BANK_TYP_ENUM_MAP.put(MM01.getUnit(), MM01);
        BANK_TYP_ENUM_MAP.put(CM01.getUnit(), CM01);
        BANK_TYP_ENUM_MAP.put(DM01.getUnit(), DM01);
        BANK_TYP_ENUM_MAP.put(M01.getUnit(), M01);
        M_TYP_ENUM_MAP.put(NAM.getUnit(), NAM);
        M_TYP_ENUM_MAP.put(uM.getUnit(), uM);
        M_TYP_ENUM_MAP.put(MM.getUnit(), MM);
        M_TYP_ENUM_MAP.put(CM.getUnit(), CM);
        M_TYP_ENUM_MAP.put(DM.getUnit(), DM);
        M_TYP_ENUM_MAP.put(M.getUnit(), M);
        M_TYP_ENUM_MAP.put(FT.getUnit(), FT);
        M_TYP_ENUM_MAP.put(KM.getUnit(), KM);
        M_TYP_ENUM_MAP.put(MI.getUnit(), MI);
        M_TYP_ENUM_MAP.put(Ml.getUnit(), Ml);
        M_TYP_ENUM_MAP.put(YD.getUnit(), YD);
    }
}

