/*
 * @(#)DirectoryReqDto.java 1.0 2018-09-17
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 目录接口
 *
 * @author 诺克
 * @since 2.0.0
 */
@ApiModel(value = "RootDirectoryReqDto", description = "根目录信息")
public class RootDirectoryReqDto extends BaseReqDto {
    /**
     * id 修改时候才用到
     */
    @ApiModelProperty(name = "id", value = "目录索引id，新增时不填，修改时必填")
    private Long id;

    @ApiModelProperty(name = "groupId", value = "分组ID，选填")
    private Long groupId;

    @ApiModelProperty(name = "link", value = "引用目录ID，选填")
    private Long link;

    @NotNull
    @ApiModelProperty(name = "code", value = "目录编码，选填")
    private String code;

    @ApiModelProperty(name = "attrs", value = "目录属性，选填")
    private String attrs;

    /**
     * 目录名
     */
    @NotNull
    @ApiModelProperty(name = "name", value = "目录名，必填")
    private String name;

    /**
     * 用途
     */

    @ApiModelProperty(name = "dirUsage", value = "用途，选填(可通过用途区分前后端目录)")
    private String dirUsage;

    /**
     * 创建人ID
     */
    @ApiModelProperty(name = "ownerId", value = "创建人ID，选填")
    private Long ownerId;

    /**
     * 排序
     */
    @ApiModelProperty(name = "sort", value = "排序，选填")
    private Long sort;

    @ApiModelProperty(name = "sellerId", value = "商户ID，选填")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID，选填")
    private Long shopId;

    @ApiModelProperty(name = "status", value = "状态 0禁用1启用，选填")
    private Integer status;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getLink() {
        return link;
    }

    public void setLink(Long link) {
        this.link = link;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDirUsage() {
        return dirUsage;
    }

    public void setDirUsage(String dirUsage) {
        this.dirUsage = dirUsage;
    }

    public Long getSort() {
        return sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
