package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "ShelfQueryRespDto", description = "上架信息返回DTO")
public class ShelfQueryRespDto extends BaseVo {

    @ApiModelProperty(name = "id")
    private Long id;
    @ApiModelProperty(name = "channelId")
    private Long channelId;
    @ApiModelProperty(name = "shopId")
    private Long shopId;
    @ApiModelProperty(name = "versionId")
    private Long versionId;
    @ApiModelProperty(name = "itemId")
    private Long itemId;
    @ApiModelProperty(name = "skuId")
    private Long skuId;
    @ApiModelProperty(name = "status", value = "0 待上架 1已上架 2已下架")
    private Integer status;
    @ApiModelProperty(name = "shelfTime")
    private Date shelfTime;
    @ApiModelProperty(name = "ownerId")
    private Long ownerId;
    @ApiModelProperty(name = "price")
    private BigDecimal price;
    @ApiModelProperty(name = "sellerId")
    private Long sellerId;
    @ApiModelProperty(name = "type")
    private Integer type;
    @ApiModelProperty(name = "itemType")
    private Integer itemType;
    @ApiModelProperty(name = "busType")
    private Integer busType;
    @ApiModelProperty(name = "shelfAmount")
    private Long shelfAmount;
    @ApiModelProperty(name = "freightTemplateId")
    private Long freightTemplateId;
    @ApiModelProperty(name = "distribution")
    private Integer distribution;
    @ApiModelProperty(name = "organizationId")
    private Long organizationId;
    @ApiModelProperty(name = "organizationName")
    private String organizationName;
    @ApiModelProperty(name = "pointsDeduction")
    private Integer pointsDeduction;

    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMinMode", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    public Integer getStockDisplay() {
        return stockDisplay;
    }

    public void setStockDisplay(Integer stockDisplay) {
        this.stockDisplay = stockDisplay;
    }

    public Integer getLimitMin() {
        return limitMin;
    }

    public void setLimitMin(Integer limitMin) {
        this.limitMin = limitMin;
    }

    public Integer getLimitMinMode() {
        return limitMinMode;
    }

    public void setLimitMinMode(Integer limitMinMode) {
        this.limitMinMode = limitMinMode;
    }

    public Integer getMultipleStatus() {
        return multipleStatus;
    }

    public void setMultipleStatus(Integer multipleStatus) {
        this.multipleStatus = multipleStatus;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getVersionId() {
        return versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getPointsDeduction() {
        return pointsDeduction;
    }

    public void setPointsDeduction(Integer pointsDeduction) {
        this.pointsDeduction = pointsDeduction;
    }
}
