package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class AuthItemRuleEsDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "ruleId", value = "主键")
    private Long ruleId;
    /**
     * 客户Id
     */
    @ApiModelProperty(name = "customerId", value = "客户Id")
    private Long customerId;
    /**
     * 客户编号
     */
    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * 授权方式,0.全部商品，1.指定品类，2.指定商品
     */
    @ApiModelProperty(name = "authType", value = "授权方式,0.全部商品，1.指定品类，2.指定商品")
    private Integer authType;
    /**
     * 指定商品类型，1.商品，2.赠品，3.物料，多个逗号隔开
     */
    @ApiModelProperty(name = "subTypes", value = "指定商品类型，1.商品，2.赠品，3.物料")
    private List<Integer> subTypes;
    /**
     * 指定商品品牌
     */
    @ApiModelProperty(name = "brandIds", value = "指定商品品牌Id")
    private List<Long> brandIds;
    /**
     * 黑名单商品
     */
    @ApiModelProperty(name = "blackItemIds", value = "黑名单商品ID")
    private List<Long> blackItemIds;
    /**
     * 指定授权商品
     */
    @ApiModelProperty(name = "customerItemIds", value = "指定授权商品Id")
    private List<Long> customerItemIds;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
}
