package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStatReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemExtDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.BuydeemItemDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
* 商品|产品定义服务接口
*
* @author yiyun
* @since 2021-08-18
*/
@Api(tags = {"商品中心：商品定义扩展服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemExtApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/extend/item",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtApi {

    /**
    * 新增商品|产品定义
    *
    * @param addReqDto 商品|产品定义请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增商品|产品定义", notes = "新增商品|产品定义")
    RestResponse<Long> addItemExt(@RequestBody ItemExtReqDto addReqDto);
    /**
    * 新增商品|产品定义
    *
    * @param addReqDto 商品|产品定义请求对象
    * @return 处理结果
    */
    @PostMapping("/createItemExt")
    @ApiOperation(value = "创建/新增物料", notes = "创建/新增物料")
    RestResponse<Long> createItemExt(@RequestBody ItemExtDto addReqDto);
    /**
     * 批量新增商品|产品定义
     *
     * @param addReqDto 批量商品|产品定义请求对象
     * @return 处理结果
     */
    @PostMapping("/batchCreateItemExt")
    @ApiOperation(value = "批量创建/新增物料", notes = "批量创建/新增物料")
    RestResponse<Void> batchCreateItemExt(@RequestBody List<ItemExtDto> addReqDto);
    /**
    * 编辑商品|产品定义
    *
    * @param addReqDto 编辑|产品定义请求对象
    * @return 处理结果
    */
    @PostMapping("/updateItemExt")
    @ApiOperation(value = "编辑物料", notes = "编辑物料")
    RestResponse<Void> updateItemExt(@RequestBody ItemExtUpdateReqDto addReqDto);
    /**
     * 根据sap更新物料信息
     *
     * @param addReqDto 根据sap更新物料信息
     * @return 处理结果
     */
    @PostMapping("/updateItemExtBySap")
    @ApiOperation(value = "根据sap更新物料信息", notes = "根据sap更新物料信息")
    RestResponse<Void> updateItemExtBySap(@RequestBody ItemExtUpdateBySapReqDto addReqDto);
    /**
    * 修改商品|产品定义
    *
    * @param modifyReqDto 商品|产品定义请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品|产品定义", notes = "修改商品|产品定义")
    RestResponse<Void> modifyItemExt(@RequestBody ItemExtReqDto modifyReqDto);

    /**
    * 删除商品|产品定义
    *
    * @param ids        商品|产品定义删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品|产品定义", notes = "删除商品|产品定义")
    RestResponse<Void> removeItemExt(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 批量新增商品信息
     *
     * @param itemExtReqDtoList 批量新增商品信息
     * @return Map<String, String>
     */
    @PostMapping("/addItemList")
    @ApiOperation(value = "批量新增商品信息", notes = "批量新增商品信息")
    RestResponse<Map<String, String>> addItemList(@RequestBody List<ItemExtReqDto> itemExtReqDtoList);

    /**
     * 上架商品
     * @param itemExtendOnShelfReqDto
     * @return
     */
    @PostMapping("/onShelf")
    @ApiOperation(value = "上架",notes = "上架")
    RestResponse<Void> onShelf(@Validated @RequestBody ItemExtendOnShelfReqDto itemExtendOnShelfReqDto);
    /**
     * 上架商品
     * @param itemExtendOnShelfReqDto
     * @return
     */
    @PostMapping("/hDOnShelf")
    @ApiOperation(value = "上架",notes = "上架")
    RestResponse<Void> hDOnShelf(@Validated @RequestBody ItemExtendOnShelfReqDto itemExtendOnShelfReqDto);

    /**
     * 商品下架
     * @param offItemReqDtos
     * @return
     */
    @PostMapping("/offShelfItem")
    @ApiOperation(value = "商品下架",notes = "商品下架")
    RestResponse<Void> offShelfItem(@Validated @NotNull @RequestBody List<ItemOffReqDto> offItemReqDtos);

    /**
     * @ApiOperation(value = "商品编辑",notes = "商品编辑")
     * @param extendReqDto
     * @return
     */
    @PostMapping(value = "/editItem")
    @ApiOperation(value = "商品编辑",notes = "商品编辑")
    RestResponse<Void> editItem(@Validated @RequestBody ItemExtendReqDto extendReqDto);

    /**
     * 增量接口获取：OA新增创建的物料主数据，审批通过后，同步至SAP，SAP推送同步至运营中台；
     * @param itemSyncReqDtoList
     * @return
     */
    @PostMapping(value = "/itemIncrementSync")
    @ApiOperation(value = "增量接口获取", notes = "增量接口获取")
    RestResponse<Void> itemIncrementSync(@RequestBody List<ItemSyncReqDto> itemSyncReqDtoList);

    /**
     * 全量同步商品数据
     * @param itemSyncReqDtoList
     * @return
     */
    @PostMapping(value = "/itemBatchSync")
    @ApiOperation(value = "全量同步商品数据", notes = "全量同步商品数据")
    RestResponse<Void> itemBatchSync(@RequestBody List<ItemSyncReqDto> itemSyncReqDtoList);

    /**
     * 保存商品库存数量
     * @param inventoryDtos
     * @return
     */
    @PostMapping(value = "/saveItemInventory")
    @ApiOperation(value = "保存商品库存数量(库存中心库存变动时调用)", notes = "保存商品库存数量(库存中心库存变动时调用)")
    RestResponse<Void> saveItemInventory(@Validated @RequestBody List<ItemInventoryDto> inventoryDtos);

    /**
     * 设置上下架商城
     * @param addressReqDto
     * @return
     */
    @PostMapping(value = "/setOnShelfAddress")
    @ApiOperation(value = "设置上下架商城", notes = "设置上下架商城")
    RestResponse<Void> setOnShelfAddress(@RequestBody OnShelfAddressReqDto addressReqDto);


    @PostMapping({"/stat/sales"})
    @ApiOperation(
            value = "设置单位时间内商品的销售数量",
            notes = "设置单位时间内商品的销售数量"
    )
    RestResponse<Void> addOrModifyItemSalesCount(@RequestBody ItemStatReqDto itemStatReqDto);


    /**
     *
     * @param itemCodes
     * @return
     */
    @PostMapping({"/pullBuydeemItemData"})
    @ApiOperation(
            value = "拉取北鼎官网商品详情并更新商品信息（图片，视频，商品介绍）",
            notes = "拉取北鼎官网商品详情并更新商品信息（图片，视频，商品介绍）"
    )
    RestResponse<Void> pullBuydeemItemData(@RequestBody(required = false) List<String> itemCodes);

    /**
     * 报错商品详情数据
     * @param detailRespDtos
     * @return
     */
    @PostMapping({"/saveBuydeemItem"})
    @ApiOperation(
            value = "保存商品详情数据(图片，视频，商品介绍)",
            notes = "保存商品详情数据(图片，视频，商品介绍)"
    )
    RestResponse<Void> saveBuydeemItem(@RequestBody List<BuydeemItemDetailRespDto> detailRespDtos);

    /**
     *
     * @param itemCodes
     * @return
     */
    @PostMapping({"/batchOnShelfItem"})
    @ApiOperation(
            value = "根据商品编码批量上架,并且批量设置允销平台",
            notes = "根据商品编码批量上架,并且批量设置允销平台"
    )
    RestResponse<Void> batchOnShelfItem(@RequestBody List<String> itemCodes);

    @PostMapping({"/batchUpdateItemControlStatus"})
    @ApiOperation(
            value = "根据商品编码 批量 更新商品管控状态",
            notes = "根据商品编码 批量 更新商品管控状态"
    )
    RestResponse<Void> batchUpdateItemControlStatus(@RequestBody ItemControlReqDto itemControlReqDto);

    @PostMapping({"/batchUpdatePushWmsStatus"})
    @ApiOperation(
            value = "根据商品ID更新是否推送过Wms",
            notes = "根据商品ID更新是否推送过Wms"
    )
    RestResponse<Void> batchUpdatePushWmsStatus(@RequestBody List<Long> itemIds,@RequestParam("pushWms") Integer pushWms,@RequestParam("thirdSystem") String thirdSystem);
}
