package com.dtyunxi.yundt.cube.center.item.api.dg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.dg.ItemExchangeUnitDgReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.dg.ItemSkuQueryDgReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemExchangeUnitDgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemRoundDgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemSkuDgRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author mubei
 * @since 1.0.0
 */
@Api(tags = {"商品中心：商品销售计划服务"})
@FeignClient( contextId = "com-yx-tcbj-center-api-IItemDgQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/dg/item",
        url = "${yundt.cube.center.item.api:}")
public interface IItemDgQueryApi {

    @PostMapping(value = "/querySkuPage")
    @ApiOperation(value = "销售计划分页查询商品sku列表", notes = "销售计划分页查询商品sku列表")
    RestResponse<PageInfo<ItemSkuDgRespDto>> querySkuPage(@RequestBody ItemSkuQueryDgReqDto itemSkuQueryDgReqDto,
                                                          @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping(value = "/querySkuList")
    @ApiOperation(value = "批量查询商品sku列表", notes = "批量查询商品sku列表", response = ItemSkuDgRespDto.class)
    RestResponse<List<ItemSkuDgRespDto>> querySkuList(@RequestBody ItemSkuQueryDgReqDto itemSkuQueryDgReqDto);

    @PostMapping(value = "/exchangeUnit")
    @ApiOperation(value = "sku单位换算", notes = "sku单位换算")
    RestResponse<ItemExchangeUnitDgRespDto> exchangeUnit(@RequestBody @Validated ItemExchangeUnitDgReqDto itemExchangeUnitDgReqDto);

    @PostMapping(value = "/batchExchangeUnit")
    @ApiOperation(value = "sku单位批量换算", notes = "sku单位批量换算")
    RestResponse<List<ItemExchangeUnitDgRespDto>> batchExchangeUnit(@RequestBody @Validated List<ItemExchangeUnitDgReqDto> reqDtos);

    @PostMapping(value = "/batchRound")
    @ApiOperation(value = "卡板/整箱取整", notes = "卡板/整箱取整")
    RestResponse<List<ItemRoundDgRespDto>> batchRound(@RequestBody @Validated List<ItemExchangeUnitDgReqDto> reqDtos);

}
