/**
 * @(#) ItemStorageInfoReqDto.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品预占信息Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStorageInfoReqDto", description = "商品预占信息Dto")
public class ItemStorageInfoReqDto extends BaseReqDto {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    private Long shopId;
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId，必填")
    private Long skuId;
    /**
     * 要预占的数目
     */
    @ApiModelProperty(name = "num", value = "要预占的数目，必填")
    private Long num;
    /**
     * 库存有效日期(今天 未来 yyyy-MM-dd)
     */
    @ApiModelProperty(name = "inventoryEffectiveDate", value = "库存有效日期(今天 未来 yyyy-MM-dd)，选填-预售场景使用")
    private String inventoryEffectiveDate;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    public String getInventoryEffectiveDate() {
        return inventoryEffectiveDate;
    }

    public void setInventoryEffectiveDate(String inventoryEffectiveDate) {
        this.inventoryEffectiveDate = inventoryEffectiveDate;
    }
}
