package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 经营屏蔽商品分页
 *
 * @author sumo
 * @date 2020/11/6 0006
 */
@ApiModel(value = "ManagementBlockRespDto", description = "经营屏蔽分页")
public class ManagementBlockRespDto extends BaseReqDto {

    @ApiModelProperty(name = "imgPath", value = "商品图片")
    private String imgPath;
    @ApiModelProperty(name = "managementBlockId", value = "经营屏蔽id")
    private Long managementBlockId;
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "itemName", value = "商品名")
    private String itemName;
    @ApiModelProperty(name = "itemStatus", value = "商品状态: 1 已上架 2已下架")
    private Integer itemStatus;
    @ApiModelProperty(name = "skuList", value = "商品SKU规格价格信息")
    private List<ItemShelfSkuRespDto> skuList;
    @ApiModelProperty(name = "itemTotalStorage", value = "商品总库存")
    private Long itemTotalStorage;

    @ApiModelProperty(name = "isAllCustomerType", value = "是否全部客户类型(1:是-0:否)")
    private Integer isAllCustomerType;
    @ApiModelProperty(name = "customerStrings", value = "客户类型前三文字展示")
    private List<String> customerTypeStrings;
    @ApiModelProperty(name = "customerIds", value = "客户类型Ids")
    private List<Long> customerTypeIds;


    @ApiModelProperty(name = "customerStrings", value = "客户文字展示")
    private List<String> customerStrings;
    @ApiModelProperty(name = "customerIds", value = "客户Ids")
    private List<Long> customerIds;


    @ApiModelProperty(name = "isAllCustomer", value = "是否全部归属区域(1:是-0:否)")
    private Integer isAllArea;
    @ApiModelProperty(name = "areaStrings", value = "归属区域前三文字展示")
    private List<String> areaStrings;
    @ApiModelProperty(name = "areaCodes", value = "归属区域 areaCodes")
    private List<String> areaCodes;

    public Integer getIsAllCustomerType() {
        return isAllCustomerType;
    }

    public void setIsAllCustomerType(Integer isAllCustomerType) {
        this.isAllCustomerType = isAllCustomerType;
    }

    public List<String> getCustomerTypeStrings() {
        return customerTypeStrings;
    }

    public void setCustomerTypeStrings(List<String> customerTypeStrings) {
        this.customerTypeStrings = customerTypeStrings;
    }

    public List<String> getCustomerStrings() {
        return customerStrings;
    }

    public void setCustomerStrings(List<String> customerStrings) {
        this.customerStrings = customerStrings;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {
        this.customerIds = customerIds;
    }

    public List<String> getAreaStrings() {
        return areaStrings;
    }

    public void setAreaStrings(List<String> areaStrings) {
        this.areaStrings = areaStrings;
    }

    public List<Long> getCustomerTypeIds() {
        return customerTypeIds;
    }

    public void setCustomerTypeIds(List<Long> customerTypeIds) {
        this.customerTypeIds = customerTypeIds;
    }

    public Integer getIsAllArea() {
        return isAllArea;
    }

    public void setIsAllArea(Integer isAllArea) {
        this.isAllArea = isAllArea;
    }

    public List<String> getAreaCodes() {
        return areaCodes;
    }

    public void setAreaCodes(List<String> areaCodes) {
        this.areaCodes = areaCodes;
    }

    public Long getItemTotalStorage() {
        return itemTotalStorage;
    }

    public void setItemTotalStorage(Long itemTotalStorage) {
        this.itemTotalStorage = itemTotalStorage;
    }

    public List<ItemShelfSkuRespDto> getSkuList() {
        return skuList;
    }

    public void setSkuList(List<ItemShelfSkuRespDto> skuList) {
        this.skuList = skuList;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public Long getManagementBlockId() {
        return managementBlockId;
    }

    public void setManagementBlockId(Long managementBlockId) {
        this.managementBlockId = managementBlockId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
