package com.dtyunxi.yundt.cube.center.item.api.base.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;

/**
 * @author 风行
 * @since 0.5.0
 */
public class ItemBusinessRuntimeException extends BizException {

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误描述
     */
    private String errorMsg;

    public ItemBusinessRuntimeException(String msg) {
        super(msg);
    }

    public ItemBusinessRuntimeException(ItemExceptionCode code){
        super(code.getCode(), code.getMsg());
    }

    public ItemBusinessRuntimeException(String errorCode, String errorMsg) {
        super(errorCode, errorMsg);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
