/*
 * @(#)ItemTradeInfoRespDto.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * <p>Title:ItemTradeInfoRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/22 16:03
 * @since 0.1.0
 */
@ApiModel(value = "ItemTradeInfoRespDto", description = "商城商品响应信息dto")
public class ItemTradeInfoRespDto implements Serializable {

    @ApiModelProperty(name = "id", value = "")
    private Long id;
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    @ApiModelProperty(name = "price", value = "商品价格")
    private String price;
    @ApiModelProperty(name = "storeCount", value = "库存数")
    private String storeCount;
    @ApiModelProperty(name = "dirId", value = "类目ID")
    private Long dirId;
    @ApiModelProperty(name = "dirName", value = "类目名称")
    private String dirName;
    @ApiModelProperty(name = "dirPrefixId", value = "前台类目ID")
    private Long dirPrefixId;
    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;
    @ApiModelProperty(name = "mediasRespDto", value = "查询商品图片")
    private ItemMediasRespDto mediasRespDto;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getStoreCount() {
        return storeCount;
    }

    public void setStoreCount(String storeCount) {
        this.storeCount = storeCount;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }

    public ItemMediasRespDto getMediasRespDto() {
        return mediasRespDto;
    }

    public void setMediasRespDto(ItemMediasRespDto mediasRespDto) {
        this.mediasRespDto = mediasRespDto;
    }
}
