package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemSycnExtReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemProValue;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.SapMaterialDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 供应商和产品的供货价格服务接口
 *
 * @author jianshi
 * @since 2021-11-11
 */
@Api(tags = {"主数据同步商品修改接口"})
@FeignClient(
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemCenter",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemSycnExtApi {

    /**
     *
     * @param itemSycnExtReqDto
     * @return 处理结果
     */
    @PostMapping("/updateItem")
    @ApiOperation(value = "修改商品信息", notes = "修改商品信息")
    RestResponse<Void> updateItem(@RequestBody List<ItemSycnExtReqDto> itemSycnExtReqDto);


    /**
     *
     * @param itemPriceReqDtoList
     * @return 处理结果
     */
    @PostMapping("/addPriceType")
    @ApiOperation(value = "添加价格类型", notes = "添加价格类型")
    RestResponse<Void> addPriceType(@RequestBody List<ItemPriceReqDto> itemPriceReqDtoList);

    /**
     * 更新或新增商品授权信息
     * @param dtoList 请求数据
     * @return 处理结果
     */
    @PostMapping("/updateOrInsertItemAuth")
    @ApiOperation(value = "更新或新增商品授权信息", notes = "更新或新增商品授权信息")
    RestResponse<Boolean> updateOrInsertItemAuth(@RequestBody List<ItemAuthReqDto> dtoList);


    @PostMapping("/addProValue")
    @ApiOperation(value = "添加规格的属性", notes = "添加规格的属性")
    RestResponse<Void> addProValue(@RequestBody ItemProValue itemProValue);

    @PostMapping("/syncSapMaterial")
    @ApiOperation(value = "同步SAP物料主数据", notes = "同步SAP物料主数据")
    RestResponse<Void> syncSapMaterial(SapMaterialDto sapMaterialDto);
}
